/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.ext.tls.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.internal.ConcurrentHashMap;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsChildChannelSource;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsServerChannel;
import org.kaazing.k3po.driver.internal.ext.tls.bootstrap.TlsServerChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractServerChannelSink;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public class TlsServerChannelSink
extends AbstractServerChannelSink<TlsServerChannel> {
    private final SecureRandom random;
    private final ConcurrentNavigableMap<ChannelAddress, TlsServerChannel> tlsBindings;
    private final ConcurrentMap<ChannelAddress, TlsTransport> tlsTransports;

    public TlsServerChannelSink(SecureRandom random) {
        this(random, new ConcurrentSkipListMap<ChannelAddress, TlsServerChannel>(ChannelAddress.ADDRESS_COMPARATOR));
    }

    private TlsServerChannelSink(SecureRandom random, ConcurrentNavigableMap<ChannelAddress, TlsServerChannel> tlsBindings) {
        this.random = random;
        this.tlsBindings = tlsBindings;
        this.tlsTransports = new ConcurrentHashMap();
    }

    @Override
    protected void bindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        ChannelAddress address;
        TlsTransport tlsTransport;
        final TlsServerChannel tlsBindChannel = (TlsServerChannel)evt.getChannel();
        final ChannelFuture tlsBindFuture = evt.getFuture();
        final ChannelAddress tlsLocalAddress = (ChannelAddress)evt.getValue();
        final URI tlsLocation = tlsLocalAddress.getLocation();
        TlsServerChannel tlsBoundChannel = this.tlsBindings.putIfAbsent(tlsLocalAddress, tlsBindChannel);
        if (tlsBoundChannel != null) {
            tlsBindFuture.setFailure((Throwable)new ChannelException(String.format("Duplicate bind failed: %s", tlsLocation)));
        }
        if ((tlsTransport = (TlsTransport)this.tlsTransports.get(address = tlsLocalAddress.getTransport())) == null) {
            TlsServerChannelConfig tlsConnectConfig = (TlsServerChannelConfig)tlsBindChannel.getConfig();
            final File keyStoreFile = tlsConnectConfig.getKeyStoreFile();
            final File trustStoreFile = tlsConnectConfig.getTrustStoreFile();
            final char[] keyStorePassword = tlsConnectConfig.getKeyStorePassword();
            final char[] trustStorePassword = tlsConnectConfig.getTrustStorePassword();
            final String[] applicationProtocols = tlsConnectConfig.getApplicationProtocols();
            final boolean wantClientAuth = tlsConnectConfig.getWantClientAuth();
            final boolean needClientAuth = tlsConnectConfig.getNeedClientAuth();
            ChannelPipelineFactory pipelineFactory = new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    KeyManager[] keyManagers = null;
                    if (keyStoreFile != null) {
                        KeyStore keys = KeyStore.getInstance("JKS");
                        keys.load(new FileInputStream(keyStoreFile), keyStorePassword);
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
                        kmf.init(keys, keyStorePassword);
                        keyManagers = kmf.getKeyManagers();
                    }
                    TrustManager[] trustManagers = null;
                    if (trustStoreFile != null) {
                        KeyStore trusts = KeyStore.getInstance("JKS");
                        trusts.load(new FileInputStream(trustStoreFile), trustStorePassword);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(trusts);
                        trustManagers = tmf.getTrustManagers();
                    }
                    SSLContext tlsContext = SSLContext.getInstance("TLS");
                    tlsContext.init(keyManagers, trustManagers, TlsServerChannelSink.this.random);
                    SSLEngine tlsEngine = tlsContext.createSSLEngine();
                    tlsEngine.setUseClientMode(false);
                    String tlsHostname = tlsLocation.getHost();
                    SSLParameters tlsParameters = new SSLParameters();
                    if (wantClientAuth) {
                        tlsParameters.setWantClientAuth(true);
                    }
                    if (needClientAuth) {
                        tlsParameters.setNeedClientAuth(true);
                    }
                    tlsParameters.setSNIMatchers(Collections.singleton(SNIHostName.createSNIMatcher(tlsHostname)));
                    if (applicationProtocols != null && applicationProtocols.length > 0) {
                        TlsServerChannelSink.setApplicationProtocols(tlsParameters, applicationProtocols);
                    }
                    tlsEngine.setSSLParameters(tlsParameters);
                    SslHandler sslHandler = new SslHandler(tlsEngine);
                    sslHandler.setIssueHandshake(true);
                    return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{sslHandler, new TlsChildChannelSource(TlsServerChannelSink.this.tlsBindings)});
                }
            };
            String schemeName = address.getLocation().getScheme();
            String tlsSchemeName = tlsLocalAddress.getLocation().getScheme();
            ServerBootstrap bootstrap = this.bootstrapFactory.newServerBootstrap(schemeName);
            bootstrap.setParentHandler(this.createParentHandler(tlsBindChannel, address));
            bootstrap.setPipelineFactory(pipelineFactory);
            bootstrap.setOptions(((TlsServerChannelConfig)tlsBindChannel.getConfig()).getTransportOptions());
            bootstrap.setOption(String.format("%s.nextProtocol", schemeName), tlsSchemeName);
            ChannelFuture bindFuture = bootstrap.bindAsync(address);
            TlsTransport newTlsTransport = new TlsTransport(bindFuture, 1);
            tlsTransport = this.tlsTransports.putIfAbsent(address, newTlsTransport);
            if (tlsTransport == null) {
                tlsTransport = newTlsTransport;
            }
        } else {
            tlsTransport.count.incrementAndGet();
        }
        if (tlsTransport.future.isDone()) {
            TlsServerChannelSink.handleTlsTransportBindComplete(tlsBindChannel, tlsBindFuture, tlsLocalAddress, tlsTransport.future);
        } else {
            tlsTransport.future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    TlsServerChannelSink.handleTlsTransportBindComplete(tlsBindChannel, tlsBindFuture, tlsLocalAddress, future);
                }
            });
        }
    }

    @Override
    protected void unbindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final TlsServerChannel tlsUnbindChannel = (TlsServerChannel)evt.getChannel();
        final ChannelFuture tlsUnbindFuture = evt.getFuture();
        ChannelAddress tlsLocalAddress = tlsUnbindChannel.getLocalAddress();
        if (!this.tlsBindings.remove(tlsLocalAddress, (Object)tlsUnbindChannel)) {
            tlsUnbindFuture.setFailure((Throwable)new ChannelException("Channel not bound"));
            return;
        }
        ChannelAddress address = tlsLocalAddress.getTransport();
        TlsTransport tlsTransport = (TlsTransport)this.tlsTransports.get(address);
        assert (tlsTransport != null);
        if (tlsTransport.count.decrementAndGet() == 0) {
            TlsTransport oldTlsTransport = new TlsTransport(tlsTransport.future);
            if (this.tlsTransports.remove(address, oldTlsTransport)) {
                Channel transport = tlsUnbindChannel.getTransport();
                ChannelFuture unbindFuture = transport.unbind();
                if (unbindFuture.isDone()) {
                    TlsServerChannelSink.handleTlsTransportUnbindComplete(tlsUnbindChannel, tlsUnbindFuture, unbindFuture);
                } else {
                    unbindFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture unbindFuture) throws Exception {
                            TlsServerChannelSink.handleTlsTransportUnbindComplete(tlsUnbindChannel, tlsUnbindFuture, unbindFuture);
                        }
                    });
                }
            }
        } else {
            Channels.fireChannelUnbound((Channel)tlsUnbindChannel);
            tlsUnbindFuture.setSuccess();
        }
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final TlsServerChannel tlsCloseChannel = (TlsServerChannel)evt.getChannel();
        final ChannelFuture tlsCloseFuture = evt.getFuture();
        boolean wasBound = tlsCloseChannel.isBound();
        if (!tlsCloseFuture.isDone()) {
            Channel transport;
            if (wasBound) {
                this.unbindRequested(pipeline, evt);
            }
            if ((transport = tlsCloseChannel.getTransport()) != null) {
                ChannelFuture closeFuture = transport.close();
                if (closeFuture.isDone()) {
                    TlsServerChannelSink.handleTlsTransportCloseComplete(tlsCloseChannel, tlsCloseFuture, closeFuture);
                } else {
                    closeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture closeFuture) throws Exception {
                            TlsServerChannelSink.handleTlsTransportCloseComplete(tlsCloseChannel, tlsCloseFuture, closeFuture);
                        }
                    });
                }
            }
        }
    }

    private ChannelHandler createParentHandler(TlsServerChannel channel, final ChannelAddress address) {
        return new SimpleChannelHandler(){

            public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                e.getChannel().setAttachment((Object)address);
                super.childChannelOpen(ctx, e);
            }
        };
    }

    private static void handleTlsTransportBindComplete(TlsServerChannel tlsBindChannel, ChannelFuture tlsBindFuture, ChannelAddress tlsLocalAddress, ChannelFuture bindFuture) {
        if (bindFuture.isSuccess()) {
            tlsBindChannel.setTransport(bindFuture.getChannel());
            tlsBindChannel.setLocalAddress(tlsLocalAddress);
            tlsBindChannel.setBound();
            Channels.fireChannelBound((Channel)tlsBindChannel, (SocketAddress)tlsBindChannel.getLocalAddress());
            tlsBindFuture.setSuccess();
        } else {
            tlsBindFuture.setFailure(bindFuture.getCause());
        }
    }

    private static void handleTlsTransportUnbindComplete(TlsServerChannel tlsUnbindChannel, ChannelFuture tlsUnbindFuture, ChannelFuture unbindFuture) {
        if (unbindFuture.isSuccess()) {
            Channels.fireChannelUnbound((Channel)tlsUnbindChannel);
            tlsUnbindFuture.setSuccess();
        } else {
            tlsUnbindFuture.setFailure(unbindFuture.getCause());
        }
    }

    private static void handleTlsTransportCloseComplete(TlsServerChannel tlsCloseChannel, ChannelFuture tlsCloseFuture, ChannelFuture closeFuture) {
        if (closeFuture.isSuccess()) {
            Channels.fireChannelClosed((Channel)tlsCloseChannel);
            tlsCloseChannel.setClosed();
        } else {
            tlsCloseFuture.setFailure(closeFuture.getCause());
        }
    }

    static void setApplicationProtocols(SSLParameters parameters, String[] protocols) {
        try {
            Method setApplicationProtocolsMethod = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            setApplicationProtocolsMethod.invoke((Object)parameters, new Object[]{protocols});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot call SSLParameters#setApplicationProtocols(). Use JDK 9 to run k3po", e);
        }
    }

    private static final class TlsTransport {
        final ChannelFuture future;
        final AtomicInteger count;

        TlsTransport(ChannelFuture future) {
            this(future, 0);
        }

        TlsTransport(ChannelFuture future, int count) {
            this.future = future;
            this.count = new AtomicInteger(count);
        }

        public int hashCode() {
            return Objects.hash(this.future, this.count);
        }

        public boolean equals(Object obj) {
            TlsTransport that = (TlsTransport)obj;
            return Objects.equals(this.future, that.future) && this.count.get() == that.count.get();
        }

        public String toString() {
            return String.format("[future=@%d, count=%d]", Objects.hashCode(this.future), this.count.get());
        }
    }
}

