/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.functions.agrona;

import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.OneToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.BroadcastTransmitterChannelWriter;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.ChannelReader;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.ChannelWriter;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.CopyBroadcastReceiverChannelReader;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.RingBufferChannelReader;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.RingBufferChannelWriter;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;

public final class Functions {
    @Function
    public static ChannelReader oneToOneReader(AtomicBuffer buffer) {
        return new RingBufferChannelReader((RingBuffer)new OneToOneRingBuffer(buffer));
    }

    @Function
    public static ChannelWriter oneToOneWriter(AtomicBuffer buffer) {
        return new RingBufferChannelWriter((RingBuffer)new OneToOneRingBuffer(buffer));
    }

    @Function
    public static ChannelReader manyToOneReader(AtomicBuffer buffer) {
        return new RingBufferChannelReader((RingBuffer)new ManyToOneRingBuffer(buffer));
    }

    @Function
    public static ChannelWriter manyToOneWriter(AtomicBuffer buffer) {
        return new RingBufferChannelWriter((RingBuffer)new ManyToOneRingBuffer(buffer));
    }

    @Function
    public static ChannelReader broadcastReceiver(AtomicBuffer buffer) {
        return new CopyBroadcastReceiverChannelReader(new FlushingCopyBroadcastReceiver(new BroadcastReceiver(buffer)));
    }

    @Function
    public static ChannelWriter broadcastTransmitter(AtomicBuffer buffer) {
        return new BroadcastTransmitterChannelWriter(new BroadcastTransmitter(buffer));
    }

    private Functions() {
    }

    private static final class FlushingCopyBroadcastReceiver
    extends CopyBroadcastReceiver {
        public FlushingCopyBroadcastReceiver(BroadcastReceiver receiver) {
            super(receiver);
            while (receiver.receiveNext()) {
            }
        }
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "agrona";
        }
    }
}

