/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.agrona;

import java.net.SocketAddress;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaClientChannel;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.AgronaChannelAddress;

public final class AgronaClientBoss
implements Runnable {
    private static final long MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final int MAX_YIELDS = 30;
    private static final int MAX_SPINS = 20;
    private final Deque<Runnable> taskQueue;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private volatile boolean shutdown;

    AgronaClientBoss() {
        this.taskQueue = new ConcurrentLinkedDeque<Runnable>();
    }

    public void connect(AgronaClientChannel channel, AgronaChannelAddress remoteAddress, ChannelFuture future) {
        this.registerTask(new ConnectTask(channel, remoteAddress, future));
    }

    @Override
    public void run() {
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(20L, 30L, MIN_PARK_NS, MAX_PARK_NS);
        while (!this.shutdown) {
            int workCount = 0;
            idleStrategy.idle(workCount += this.executeTasks());
        }
        this.shutdownLatch.countDown();
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private int executeTasks() {
        Runnable task;
        int workCount = 0;
        while ((task = this.taskQueue.poll()) != null) {
            task.run();
            ++workCount;
        }
        return workCount;
    }

    private void registerTask(Runnable task) {
        this.taskQueue.offer(task);
    }

    private static final class ConnectTask
    implements Runnable {
        private final AgronaClientChannel clientChannel;
        private final AgronaChannelAddress remoteAddress;
        private final ChannelFuture connectFuture;

        public ConnectTask(AgronaClientChannel clientChannel, AgronaChannelAddress remoteAddress, ChannelFuture bindFuture) {
            this.clientChannel = clientChannel;
            this.connectFuture = bindFuture;
            this.remoteAddress = remoteAddress;
        }

        @Override
        public void run() {
            this.clientChannel.setRemoteAddress(this.remoteAddress);
            this.clientChannel.setConnected();
            Channels.fireChannelConnected((Channel)this.clientChannel, (SocketAddress)this.clientChannel.getRemoteAddress());
            this.connectFuture.setSuccess();
            this.clientChannel.worker.register(this.clientChannel);
        }
    }
}

