/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshChildChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshHttpHeaders;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshPollingChildChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChildChannel;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.SimpleChannelHandler;

public class BBoshPollingChildChannelSource
extends SimpleChannelHandler {
    private static final ChannelFutureListener READ_RESUMER = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            Channel channel = future.getChannel();
            channel.setReadable(true);
        }
    };
    private final BBoshChildChannel bboshChannel;
    private final BBoshPollingChildChannelSink bboshChannelSink;

    public BBoshPollingChildChannelSource(BBoshChildChannel bboshChannel) {
        this.bboshChannel = bboshChannel;
        this.bboshChannelSink = (BBoshPollingChildChannelSink)bboshChannel.getPipeline().getSink();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        HttpChildChannel httpChannel = (HttpChildChannel)ctx.getChannel();
        HttpChannelConfig httpConfig = (HttpChannelConfig)httpChannel.getConfig();
        HttpHeaders httpHeaders = httpConfig.getReadHeaders();
        int sequenceNo = BBoshHttpHeaders.getIntHeader(httpHeaders, "X-Sequence-No");
        ChannelFuture attachFuture = this.bboshChannelSink.attach(sequenceNo, httpChannel);
        if (!attachFuture.isDone()) {
            httpChannel.setReadable(false);
            attachFuture.addListener(READ_RESUMER);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object message = e.getMessage();
        org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.bboshChannel, (Object)message);
    }

    @Override
    public void inputShutdown(ChannelHandlerContext ctx, ShutdownInputEvent e) {
        HttpChildChannel httpChannel = (HttpChildChannel)ctx.getChannel();
        HttpChannelConfig httpConfig = (HttpChannelConfig)httpChannel.getConfig();
        HttpMethod httpMethod = httpConfig.getMethod();
        if (HttpMethod.DELETE.getName().equalsIgnoreCase(httpMethod.getName())) {
            Channels.shutdownOutput((Channel)httpChannel);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        HttpChildChannel httpChannel = (HttpChildChannel)ctx.getChannel();
        HttpChannelConfig httpConfig = (HttpChannelConfig)httpChannel.getConfig();
        HttpMethod httpMethod = httpConfig.getMethod();
        this.bboshChannelSink.detach(httpChannel);
        if (HttpMethod.DELETE.getName().equalsIgnoreCase(httpMethod.getName()) && this.bboshChannel.setClosed()) {
            org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)this.bboshChannel);
            org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)this.bboshChannel);
            org.jboss.netty.channel.Channels.fireChannelClosed((Channel)this.bboshChannel);
        }
    }
}

