/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh;

import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshHandshakeChildChannelPipelineFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh.BBoshServerChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractServerChannelSink;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;

public class BBoshServerChannelSink
extends AbstractServerChannelSink<BBoshServerChannel> {
    private final BBoshHandshakeChildChannelPipelineFactory pipelineFactory;
    private final ConcurrentNavigableMap<URI, BBoshServerChannel> bboshBindings;

    public BBoshServerChannelSink() {
        this(new ConcurrentSkipListMap<URI, BBoshServerChannel>());
    }

    private BBoshServerChannelSink(ConcurrentNavigableMap<URI, BBoshServerChannel> bboshBindings) {
        this.pipelineFactory = new BBoshHandshakeChildChannelPipelineFactory(bboshBindings);
        this.bboshBindings = bboshBindings;
    }

    public void setAddressFactory(ChannelAddressFactory addressFactory) {
        this.pipelineFactory.setAddressFactory(addressFactory);
    }

    @Override
    public void setBootstrapFactory(BootstrapFactory bootstrapFactory) {
        super.setBootstrapFactory(bootstrapFactory);
        this.pipelineFactory.setBootstrapFactory(bootstrapFactory);
    }

    @Override
    protected void bindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final BBoshServerChannel bboshBindChannel = (BBoshServerChannel)evt.getChannel();
        final ChannelFuture bboshBindFuture = evt.getFuture();
        final ChannelAddress bboshLocalAddress = (ChannelAddress)evt.getValue();
        URI bboshLocation = bboshLocalAddress.getLocation();
        BBoshServerChannel bboshBoundChannel = this.bboshBindings.putIfAbsent(bboshLocation, bboshBindChannel);
        if (bboshBoundChannel != null) {
            bboshBindFuture.setFailure((Throwable)new ChannelException(String.format("Duplicate bind failed: %s", bboshLocation)));
        }
        ChannelAddress address = bboshLocalAddress.getTransport();
        String schemeName = address.getLocation().getScheme();
        String bboshSchemeName = bboshLocalAddress.getLocation().getScheme();
        ServerBootstrap bootstrap = this.bootstrapFactory.newServerBootstrap(schemeName);
        bootstrap.setParentHandler(this.createParentHandler(bboshBindChannel));
        bootstrap.setPipelineFactory(this.pipelineFactory);
        bootstrap.setOption(String.format("%s.nextProtocol", schemeName), bboshSchemeName);
        ChannelFuture bindFuture = bootstrap.bindAsync(address);
        if (bindFuture.isDone()) {
            BBoshServerChannelSink.handleBBoshTransportBindComplete(bboshBindChannel, bboshBindFuture, bboshLocalAddress, bindFuture);
        } else {
            bindFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture bindFuture) throws Exception {
                    BBoshServerChannelSink.handleBBoshTransportBindComplete(bboshBindChannel, bboshBindFuture, bboshLocalAddress, bindFuture);
                }
            });
        }
    }

    @Override
    protected void unbindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final BBoshServerChannel bboshUnbindChannel = (BBoshServerChannel)evt.getChannel();
        final ChannelFuture bboshUnbindFuture = evt.getFuture();
        ChannelAddress bboshLocalAddress = bboshUnbindChannel.getLocalAddress();
        URI bboshLocation = bboshLocalAddress.getLocation();
        if (!this.bboshBindings.remove(bboshLocation, (Object)bboshUnbindChannel)) {
            bboshUnbindFuture.setFailure((Throwable)new ChannelException("Channel not bound"));
            return;
        }
        Channel transport = bboshUnbindChannel.getTransport();
        ChannelFuture unbindFuture = transport.unbind();
        if (unbindFuture.isDone()) {
            BBoshServerChannelSink.handleBBoshTransportUnbindComplete(bboshUnbindChannel, bboshUnbindFuture, unbindFuture);
        } else {
            unbindFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture unbindFuture) throws Exception {
                    BBoshServerChannelSink.handleBBoshTransportUnbindComplete(bboshUnbindChannel, bboshUnbindFuture, unbindFuture);
                }
            });
        }
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final BBoshServerChannel bboshCloseChannel = (BBoshServerChannel)evt.getChannel();
        final ChannelFuture bboshCloseFuture = evt.getFuture();
        boolean wasBound = bboshCloseChannel.isBound();
        if (bboshCloseChannel.setClosed()) {
            Channel transport;
            if (wasBound) {
                this.unbindRequested(pipeline, evt);
            }
            if ((transport = bboshCloseChannel.getTransport()) != null) {
                ChannelFuture closeFuture = transport.close();
                if (closeFuture.isDone()) {
                    BBoshServerChannelSink.handleBBoshTransportCloseComplete(bboshCloseChannel, bboshCloseFuture, closeFuture);
                } else {
                    closeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture closeFuture) throws Exception {
                            BBoshServerChannelSink.handleBBoshTransportCloseComplete(bboshCloseChannel, bboshCloseFuture, closeFuture);
                        }
                    });
                }
            }
        }
    }

    private ChannelHandler createParentHandler(BBoshServerChannel channel) {
        return new SimpleChannelHandler(){
            private final ChannelGroup childChannels = new DefaultChannelGroup();

            public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                this.childChannels.add((Object)e.getChildChannel());
                super.childChannelOpen(ctx, e);
            }

            public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                this.childChannels.remove((Object)e.getChildChannel());
                super.childChannelClosed(ctx, e);
            }

            public void closeRequested(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
                this.childChannels.close().addListener(new ChannelGroupFutureListener(){

                    public void operationComplete(ChannelGroupFuture future) throws Exception {
                        ctx.sendDownstream((ChannelEvent)e);
                    }
                });
            }
        };
    }

    private static void handleBBoshTransportBindComplete(BBoshServerChannel bboshBindChannel, ChannelFuture bboshBindFuture, ChannelAddress bboshLocalAddress, ChannelFuture future) {
        if (future.isSuccess()) {
            bboshBindChannel.setTransport(future.getChannel());
            bboshBindChannel.setLocalAddress(bboshLocalAddress);
            bboshBindChannel.setBound();
            Channels.fireChannelBound((Channel)bboshBindChannel, (SocketAddress)bboshBindChannel.getLocalAddress());
            bboshBindFuture.setSuccess();
        } else {
            bboshBindFuture.setFailure(future.getCause());
        }
    }

    private static void handleBBoshTransportUnbindComplete(BBoshServerChannel bboshUnbindChannel, ChannelFuture bboshUnbindFuture, ChannelFuture future) {
        if (future.isSuccess()) {
            Channels.fireChannelUnbound((Channel)bboshUnbindChannel);
            bboshUnbindFuture.setSuccess();
        } else {
            bboshUnbindFuture.setFailure(future.getCause());
        }
    }

    private static void handleBBoshTransportCloseComplete(BBoshServerChannel bboshCloseChannel, ChannelFuture bboshCloseFuture, ChannelFuture closeFuture) {
        if (closeFuture.isSuccess()) {
            Channels.fireChannelClosed((Channel)bboshCloseChannel);
            bboshCloseFuture.setSuccess();
        } else {
            bboshCloseFuture.setFailure(closeFuture.getCause());
        }
    }
}

