/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.bbosh;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BBoshStrategy {
    public abstract Kind getKind();

    public abstract int getRequests();

    public abstract long getInterval(TimeUnit var1);

    public static BBoshStrategy valueOf(String strategy) {
        if (strategy != null && !strategy.isEmpty()) {
            switch (strategy.charAt(0)) {
                case 'p': {
                    Matcher pollingMatcher = Polling.PATTERN.matcher(strategy);
                    if (!pollingMatcher.matches()) break;
                    int interval = Integer.parseInt(pollingMatcher.group(1));
                    TimeUnit intervalUnit = TimeUnit.SECONDS;
                    return new Polling(interval, intervalUnit);
                }
                case 'l': {
                    Matcher longPollingMatcher = LongPolling.PATTERN.matcher(strategy);
                    if (!longPollingMatcher.matches()) break;
                    int interval = Integer.parseInt(longPollingMatcher.group(1));
                    TimeUnit intervalUnit = TimeUnit.SECONDS;
                    String requests = longPollingMatcher.group(2);
                    if (requests != null) {
                        return new LongPolling(interval, intervalUnit, Integer.parseInt(requests));
                    }
                    return new LongPolling(interval, intervalUnit);
                }
                case 's': {
                    Matcher streamingMatcher = Streaming.PATTERN.matcher(strategy);
                    if (!streamingMatcher.matches()) break;
                    return new Streaming();
                }
            }
        }
        return null;
    }

    public static final class Streaming
    extends BBoshStrategy {
        private static final Pattern PATTERN = Pattern.compile("streaming;request=chunked");

        Streaming() {
        }

        @Override
        public Kind getKind() {
            return Kind.STREAMING;
        }

        @Override
        public long getInterval(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int getRequests() {
            return 1;
        }

        public String toString() {
            return "streaming;request=chunked";
        }
    }

    public static final class LongPolling
    extends BBoshStrategy {
        private static final Pattern PATTERN = Pattern.compile("long-polling;interval=([0-9]+)s(?:;requests=([0-9]+))");
        private final int interval;
        private final TimeUnit intervalUnit;
        private final int requests;

        LongPolling(int interval, TimeUnit intervalUnit) {
            this(interval, intervalUnit, 2);
        }

        LongPolling(int interval, TimeUnit intervalUnit, int requests) {
            this.interval = interval;
            this.intervalUnit = intervalUnit;
            this.requests = requests;
        }

        @Override
        public Kind getKind() {
            return Kind.LONG_POLLING;
        }

        @Override
        public long getInterval(TimeUnit unit) {
            return unit.convert(this.interval, this.intervalUnit);
        }

        @Override
        public int getRequests() {
            return this.requests;
        }

        public String toString() {
            return String.format("long-polling;interval=%d%s;requests=%d", this.interval, Character.valueOf(Character.toLowerCase(this.intervalUnit.name().charAt(0))), this.requests);
        }
    }

    public static final class Polling
    extends BBoshStrategy {
        private static final Pattern PATTERN = Pattern.compile("polling;interval=([0-9]+)s");
        private final int interval;
        private final TimeUnit intervalUnit;

        Polling(int interval, TimeUnit intervalUnit) {
            this.interval = interval;
            this.intervalUnit = intervalUnit;
        }

        @Override
        public Kind getKind() {
            return Kind.POLLING;
        }

        @Override
        public long getInterval(TimeUnit unit) {
            return unit.convert(this.interval, this.intervalUnit);
        }

        @Override
        public int getRequests() {
            return 1;
        }

        public String toString() {
            return String.format("polling;interval=%d%s", this.interval, Character.valueOf(Character.toLowerCase(this.intervalUnit.name().charAt(0))));
        }
    }

    public static enum Kind {
        POLLING,
        LONG_POLLING,
        STREAMING;

    }
}

