/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.channel;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ServerChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public abstract class AbstractChannel<T extends ChannelConfig>
extends org.jboss.netty.channel.AbstractChannel {
    private static final int ST_OPEN = 0;
    private static final int ST_BOUND = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSED = -1;
    private final T config;
    private final AtomicInteger closeState;
    private final AtomicInteger abortState;
    private volatile int state;
    private volatile ChannelAddress localAddress;
    private volatile ChannelAddress remoteAddress;

    public AbstractChannel(ServerChannel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, T config) {
        super((Channel)parent, factory, pipeline, sink);
        this.config = config;
        this.closeState = new AtomicInteger();
        this.abortState = new AtomicInteger();
        this.state = 0;
    }

    public T getConfig() {
        return this.config;
    }

    public ChannelAddress getLocalAddress() {
        return this.state >= 1 ? this.localAddress : null;
    }

    public ChannelAddress getRemoteAddress() {
        return this.state == 2 ? this.remoteAddress : null;
    }

    public boolean isOpen() {
        return this.state >= 0;
    }

    public boolean isBound() {
        return this.state >= 1;
    }

    public boolean isConnected() {
        return this.state == 2;
    }

    protected void setBound() {
        assert (this.state == 0) : String.format("Invalid state: %s", this.state);
        this.state = 1;
    }

    protected void setConnected() {
        if (this.state != -1) {
            this.state = 2;
        }
    }

    protected boolean setClosed() {
        return this.setClosed0();
    }

    protected void setLocalAddress(ChannelAddress localAddress) {
        this.localAddress = localAddress;
    }

    protected void setRemoteAddress(ChannelAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    protected boolean isReadClosed() {
        return (this.closeState.get() & 1) != 0;
    }

    protected boolean isWriteClosed() {
        return (this.closeState.get() & 2) != 0;
    }

    protected boolean setReadClosed() {
        int closeStatus;
        if ((this.closeState.get() & 1) == 0 && (closeStatus = this.closeState.addAndGet(1)) == 3) {
            return this.setClosed0();
        }
        return false;
    }

    protected boolean setWriteClosed() {
        int closeStatus;
        if ((this.closeState.get() & 2) == 0 && (closeStatus = this.closeState.addAndGet(2)) == 3) {
            return this.setClosed0();
        }
        return false;
    }

    protected boolean isReadAborted() {
        return (this.abortState.get() & 1) != 0;
    }

    protected boolean isWriteAborted() {
        return (this.abortState.get() & 2) != 0;
    }

    protected boolean setReadAborted() {
        if ((this.abortState.get() & 1) == 0) {
            this.abortState.addAndGet(1);
            return true;
        }
        return false;
    }

    protected boolean setWriteAborted() {
        if ((this.abortState.get() & 2) == 0) {
            this.abortState.addAndGet(2);
            return true;
        }
        return false;
    }

    private boolean setClosed0() {
        this.state = -1;
        return super.setClosed();
    }
}

