/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.tcp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerBossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.executor.ExecutorServiceFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactorySpi;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public final class TcpBootstrapFactorySpi
extends BootstrapFactorySpi
implements ExternalResourceReleasable {
    private final Collection<ChannelFactory> channelFactories = new ConcurrentLinkedDeque<ChannelFactory>();
    private ExecutorServiceFactory executorServiceFactory;
    private NioClientSocketChannelFactory clientChannelFactory;
    private NioServerSocketChannelFactory serverChannelFactory;

    @Resource
    public void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    @Resource
    public void setNioClientSocketChannelFactory(NioClientSocketChannelFactory clientChannelFactory) {
        this.clientChannelFactory = clientChannelFactory;
    }

    @Resource
    public void setNioServerSocketChannelFactory(NioServerSocketChannelFactory serverChannelFactory) {
        this.serverChannelFactory = serverChannelFactory;
    }

    @Override
    public String getTransportName() {
        return "tcp";
    }

    @Override
    public void shutdown() {
        for (ChannelFactory channelFactory : this.channelFactories) {
            channelFactory.shutdown();
        }
    }

    @Override
    public void releaseExternalResources() {
        for (ChannelFactory channelFactory : this.channelFactories) {
            channelFactory.releaseExternalResources();
        }
    }

    @Override
    public synchronized ClientBootstrap newClientBootstrap() throws Exception {
        NioClientSocketChannelFactory clientChannelFactory = this.clientChannelFactory;
        if (clientChannelFactory == null) {
            ExecutorService bossExecutor = this.executorServiceFactory.newExecutorService("boss.client");
            NioClientBossPool bossPool = new NioClientBossPool((Executor)bossExecutor, 1);
            ExecutorService workerExecutor = this.executorServiceFactory.newExecutorService("worker.client");
            NioWorkerPool workerPool = new NioWorkerPool((Executor)workerExecutor, 1);
            clientChannelFactory = new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
            this.channelFactories.add((ChannelFactory)clientChannelFactory);
        }
        return new ClientBootstrap((ChannelFactory)clientChannelFactory){

            public ChannelFuture connect(SocketAddress localAddress, SocketAddress remoteAddress) {
                InetSocketAddress localChannelAddress = Channels.toInetSocketAddress((ChannelAddress)localAddress);
                InetSocketAddress remoteChannelAddress = Channels.toInetSocketAddress((ChannelAddress)remoteAddress);
                return super.connect((SocketAddress)localChannelAddress, (SocketAddress)remoteChannelAddress);
            }
        };
    }

    @Override
    public synchronized ServerBootstrap newServerBootstrap() throws Exception {
        NioServerSocketChannelFactory serverChannelFactory = this.serverChannelFactory;
        if (serverChannelFactory == null) {
            ExecutorService bossExecutor = this.executorServiceFactory.newExecutorService("boss.server");
            NioServerBossPool bossPool = new NioServerBossPool((Executor)bossExecutor, 1);
            ExecutorService workerExecutor = this.executorServiceFactory.newExecutorService("worker.server");
            NioWorkerPool workerPool = new NioWorkerPool((Executor)workerExecutor, 1);
            serverChannelFactory = new NioServerSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
            this.channelFactories.add((ChannelFactory)serverChannelFactory);
        }
        return new ServerBootstrap((ChannelFactory)serverChannelFactory){

            public ChannelFuture bindAsync(SocketAddress localAddress) {
                return super.bindAsync((SocketAddress)Channels.toInetSocketAddress(localAddress));
            }
        };
    }
}

