/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannel;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamFlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamReadAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamReadAdviseEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamWriteAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamWriteAdviseEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamFlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamReadAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamReadAdviseEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamWriteAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamWriteAdviseEvent;

public final class Channels {
    public static void fireInputShutdown(ChannelHandlerContext ctx) {
        ctx.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownInputEvent(ctx.getChannel()));
    }

    public static void fireInputShutdown(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownInputEvent(channel));
    }

    public static void fireFlushed(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamFlushEvent(channel));
    }

    public static ChannelFuture shutdownInput(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamShutdownInputEvent(channel, future));
        return future;
    }

    public static void shutdownInput(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamShutdownInputEvent(ctx.getChannel(), future));
    }

    public static void fireOutputShutdown(ChannelHandlerContext ctx) {
        ctx.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownOutputEvent(ctx.getChannel()));
    }

    public static void fireOutputShutdown(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownOutputEvent(channel));
    }

    public static ChannelFuture shutdownOutput(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamShutdownOutputEvent(channel, future));
        return future;
    }

    public static void shutdownOutput(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamShutdownOutputEvent(ctx.getChannel(), future));
    }

    public static ChannelFuture flush(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamFlushEvent(channel, future));
        return future;
    }

    public static void flush(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamFlushEvent(ctx.getChannel(), future));
    }

    public static ChannelFuture abortOutput(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamWriteAbortEvent(channel, future));
        return future;
    }

    public static void abortOutput(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamWriteAbortEvent(ctx.getChannel(), future));
    }

    public static void fireOutputAborted(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamWriteAbortEvent(channel));
    }

    public static ChannelFuture abortInput(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamReadAbortEvent(channel, future));
        return future;
    }

    public static void abortInput(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamReadAbortEvent(ctx.getChannel(), future));
    }

    public static void fireInputAborted(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamReadAbortEvent(channel));
    }

    public static ChannelFuture adviseOutput(Channel channel, Object value) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamWriteAdviseEvent(channel, future, value));
        return future;
    }

    public static void adviseOutput(ChannelHandlerContext ctx, ChannelFuture future, Object value) {
        ctx.sendDownstream((ChannelEvent)new DownstreamWriteAdviseEvent(ctx.getChannel(), future, value));
    }

    public static void fireOutputAdvised(Channel channel, Object value) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamWriteAdviseEvent(channel, value));
    }

    public static ChannelFuture adviseInput(Channel channel, Object value) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamReadAdviseEvent(channel, future, value));
        return future;
    }

    public static void adviseInput(ChannelHandlerContext ctx, ChannelFuture future, Object value) {
        ctx.sendDownstream((ChannelEvent)new DownstreamReadAdviseEvent(ctx.getChannel(), future, value));
    }

    public static void fireInputAdvised(Channel channel, Object value) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamReadAdviseEvent(channel, value));
    }

    public static ChannelFuture shutdownOutputOrClose(Channel channel) {
        if (channel instanceof AbstractChannel) {
            return Channels.shutdownOutput(channel);
        }
        return org.jboss.netty.channel.Channels.close((Channel)channel);
    }

    public static void shutdownOutputOrClose(ChannelHandlerContext ctx, ChannelFuture future) {
        if (ctx.getChannel() instanceof AbstractChannel) {
            Channels.shutdownOutput(ctx, future);
        } else {
            org.jboss.netty.channel.Channels.close((ChannelHandlerContext)ctx, (ChannelFuture)future);
        }
    }

    public static ChannelFuture abortOutputOrClose(Channel channel) {
        if (channel instanceof AbstractChannel) {
            return Channels.abortOutput(channel);
        }
        return org.jboss.netty.channel.Channels.close((Channel)channel);
    }

    public static void abortOutputOrClose(ChannelHandlerContext ctx, ChannelFuture future) {
        if (ctx.getChannel() instanceof AbstractChannel) {
            Channels.abortOutput(ctx, future);
        } else {
            org.jboss.netty.channel.Channels.close((ChannelHandlerContext)ctx, (ChannelFuture)future);
        }
    }

    public static void abortInputOrSuccess(ChannelHandlerContext ctx, ChannelFuture future) {
        if (ctx.getChannel() instanceof AbstractChannel) {
            Channels.abortInput(ctx, future);
        } else {
            future.setSuccess();
        }
    }

    private Channels() {
    }
}

