/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.resolver;

import java.net.URI;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;
import org.kaazing.k3po.driver.internal.resolver.OptionsResolver;

public class ClientBootstrapResolver {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ClientBootstrapResolver.class);
    private final BootstrapFactory bootstrapFactory;
    private final ChannelAddressFactory addressFactory;
    private final ChannelPipelineFactory pipelineFactory;
    private final Supplier<URI> locationResolver;
    private final Barrier awaitBarrier;
    private final OptionsResolver optionsResolver;
    private ClientBootstrap bootstrap;

    public ClientBootstrapResolver(BootstrapFactory bootstrapFactory, ChannelAddressFactory addressFactory, ChannelPipelineFactory pipelineFactory, Supplier<URI> locationResolver, OptionsResolver optionsResolver, Barrier awaitBarrier) {
        this.bootstrapFactory = bootstrapFactory;
        this.addressFactory = addressFactory;
        this.pipelineFactory = pipelineFactory;
        this.locationResolver = locationResolver;
        this.optionsResolver = optionsResolver;
        this.awaitBarrier = awaitBarrier;
    }

    public ClientBootstrap resolve() throws Exception {
        if (this.bootstrap == null) {
            URI connectURI = this.locationResolver.get();
            Map<String, Object> connectOptions = this.optionsResolver.resolve();
            ChannelAddress remoteAddress = this.addressFactory.newChannelAddress(connectURI, connectOptions);
            LOGGER.debug("Initializing client Bootstrap connecting to remoteAddress " + remoteAddress);
            ClientBootstrap clientBootstrapCandidate = this.bootstrapFactory.newClientBootstrap(connectURI.getScheme());
            clientBootstrapCandidate.setPipelineFactory(this.pipelineFactory);
            clientBootstrapCandidate.setOptions(connectOptions);
            clientBootstrapCandidate.setOption("remoteAddress", remoteAddress);
            this.bootstrap = clientBootstrapCandidate;
        }
        return this.bootstrap;
    }

    public Barrier getAwaitBarrier() {
        return this.awaitBarrier;
    }
}

