/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.rules;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.rules.Verifier;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runners.model.Statement;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.Latch;
import org.kaazing.k3po.junit.rules.SpecificationStatement;
import org.kaazing.net.URLFactory;

public class K3poRule
extends Verifier {
    private static final Pattern NAMED_PACKAGE_PATH_PATTERN = Pattern.compile("\\$\\{([A-Za-z]+)\\}(.+)");
    private final Latch latch = new Latch();
    private String scriptRoot;
    private URL controlURL;
    private SpecificationStatement statement;
    private List<String> classOverriddenProperties = new ArrayList<String>();
    private Map<String, String> packagePathsByName = new HashMap<String, String>();

    public K3poRule() {
        if (Thread.interrupted()) {
            System.out.println("Warning - thread had interrupted status = true before test start");
        }
    }

    public K3poRule setScriptRoot(String packagePath) {
        this.scriptRoot = packagePath;
        return this;
    }

    public K3poRule addScriptRoot(String shortName, String packagePath) {
        this.packagePathsByName.put(shortName, packagePath);
        return this;
    }

    public K3poRule setControlURI(URI controlURI) {
        this.controlURL = K3poRule.createURL(controlURI.toString());
        return this;
    }

    public Statement apply(Statement statement, Description description) {
        Specification specification = (Specification)description.getAnnotation(Specification.class);
        String[] scripts = specification != null ? specification.value() : null;
        ScriptProperty overriddenProperty = (ScriptProperty)description.getAnnotation(ScriptProperty.class);
        String[] overriddenProperties = overriddenProperty != null ? overriddenProperty.value() : null;
        ArrayList<String> methodOverridenScriptProperties = new ArrayList<String>();
        if (overriddenProperties != null) {
            for (String prop : overriddenProperties) {
                methodOverridenScriptProperties.add(prop);
            }
        }
        if (scripts != null) {
            LinkedList<String> scriptNames = new LinkedList<String>();
            for (String script : scripts) {
                if (script.startsWith("/")) {
                    throw new IllegalArgumentException("Script path must be relative");
                }
                Matcher matcher = NAMED_PACKAGE_PATH_PATTERN.matcher(script);
                if (matcher.matches()) {
                    String shortName = matcher.group(1);
                    String relativePath = matcher.group(2);
                    String packagePath = this.packagePathsByName.get(shortName);
                    if (packagePath == null) {
                        throw new IllegalArgumentException("Script short name not found: " + shortName);
                    }
                    String scriptName = String.format("%s/%s", packagePath, relativePath);
                    scriptNames.add(scriptName);
                    continue;
                }
                String packagePath = this.getScriptRoot(description);
                String scriptName = String.format("%s/%s", packagePath, script);
                scriptNames.add(scriptName);
            }
            URL controlURL = this.controlURL;
            if (controlURL == null) {
                controlURL = K3poRule.createURL("tcp://localhost:11642");
            }
            methodOverridenScriptProperties.addAll(this.classOverriddenProperties);
            this.statement = new SpecificationStatement(statement, controlURL, scriptNames, this.latch, methodOverridenScriptProperties);
            statement = this.statement;
        }
        return super.apply(statement, description);
    }

    public void start() {
        Assert.assertTrue((String)String.format("Did you call start() from outside @%s test?", Specification.class.getSimpleName()), (boolean)this.latch.isPrepared());
        this.latch.notifyStartable();
    }

    public void finish() throws Exception {
        Assert.assertTrue((String)String.format("Did you call finish() from outside @%s test?", Specification.class.getSimpleName()), (!this.latch.isInInitState() ? 1 : 0) != 0);
        this.latch.notifyStartable();
        this.latch.awaitFinished();
    }

    private static URL createURL(String location) {
        try {
            return URLFactory.createURL((String)"tcp://localhost:11642");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void awaitBarrier(String barrierName) throws Exception {
        this.statement.awaitBarrier(barrierName);
    }

    public K3poRule scriptProperty(String property) {
        this.classOverriddenProperties.add(property);
        return this;
    }

    public void notifyBarrier(String barrierName) throws Exception {
        this.statement.notifyBarrier(barrierName);
    }

    private String getScriptRoot(Description description) {
        if (this.scriptRoot == null) {
            Class testClass = description.getTestClass();
            String packageName = testClass.getPackage().getName();
            return packageName.replaceAll("\\.", "/");
        }
        return this.scriptRoot;
    }

    static {
        JUnitCore core = new JUnitCore();
        String version = core.getVersion();
        String[] versionTokens = version.split("\\.");
        Integer[] versionsInt = new Integer[versionTokens.length];
        for (int i = 0; i < versionTokens.length; ++i) {
            String versionToken = versionTokens[i];
            if (versionToken.contains("-")) {
                versionToken = versionToken.substring(0, versionToken.indexOf("-"));
            }
            versionsInt[i] = Integer.parseInt(versionToken);
        }
        if (versionsInt[0] < 5 && (versionsInt.length == 1 || versionsInt[0] < 4 || versionsInt[1] < 10)) {
            throw new AssertionError((Object)("JUnit library 4.10+ required. Found version " + version));
        }
    }
}

