/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.rules;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

class Latch {
    private volatile State state;
    private volatile Exception exception;
    private final CountDownLatch prepared;
    private final CountDownLatch startable;
    private final CountDownLatch finished;
    private volatile Thread testThread;
    private final AtomicBoolean testThreadInterrupted = new AtomicBoolean(false);

    Latch() {
        this.state = State.INIT;
        this.prepared = new CountDownLatch(1);
        this.startable = new CountDownLatch(1);
        this.finished = new CountDownLatch(1);
    }

    void notifyPrepared() {
        switch (this.state) {
            case INIT: {
                this.state = State.PREPARED;
                this.prepared.countDown();
                break;
            }
            default: {
                throw new IllegalStateException(this.state.name());
            }
        }
    }

    void awaitPrepared() throws Exception {
        this.prepared.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    boolean isPrepared() {
        return this.prepared.getCount() == 0L;
    }

    boolean isInInitState() {
        return this.state == State.INIT;
    }

    void notifyStartable() {
        switch (this.state) {
            case PREPARED: {
                this.state = State.STARTABLE;
                this.startable.countDown();
                break;
            }
            case STARTABLE: 
            case FINISHED: {
                break;
            }
            default: {
                throw new IllegalStateException(this.state.name());
            }
        }
    }

    void awaitStartable() throws Exception {
        this.startable.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    boolean isStartable() {
        return this.startable.getCount() == 0L;
    }

    void notifyFinished() {
        switch (this.state) {
            case INIT: {
                this.notifyPrepared();
            }
            case PREPARED: 
            case STARTABLE: {
                this.state = State.FINISHED;
                this.finished.countDown();
                break;
            }
            default: {
                throw new IllegalStateException(this.state.name());
            }
        }
    }

    void notifyAbort() {
        switch (this.state) {
            case INIT: {
                this.notifyPrepared();
            }
            case PREPARED: {
                this.notifyStartable();
                break;
            }
        }
    }

    void awaitFinished() throws Exception {
        this.finished.await();
    }

    boolean isFinished() {
        return this.finished.getCount() == 0L;
    }

    boolean hasException() {
        return this.exception != null;
    }

    void notifyException(Exception exception) {
        this.exception = Objects.requireNonNull(exception);
        if (!Thread.currentThread().equals(this.testThread) && this.testThreadInterrupted.compareAndSet(false, true)) {
            this.testThread.interrupt();
        }
    }

    public void setInterruptOnException(Thread testThread) {
        this.testThread = testThread;
    }

    public Exception getException() {
        return this.exception;
    }

    static enum State {
        INIT,
        PREPARED,
        STARTABLE,
        FINISHED;

    }
}

