/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.rules;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.kaazing.k3po.junit.rules.Latch;
import org.kaazing.k3po.junit.rules.ScriptRunner;
import org.kaazing.k3po.junit.rules.internal.ScriptPair;

final class SpecificationStatement
extends Statement {
    private final Statement statement;
    private final Latch latch;
    private final ScriptRunner scriptRunner;

    SpecificationStatement(Statement statement, URL controlURL, List<String> scriptNames, Latch latch, List<String> overridenScriptProperties) {
        this.statement = statement;
        this.latch = latch;
        this.scriptRunner = new ScriptRunner(controlURL, scriptNames, latch, overridenScriptProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        this.latch.setInterruptOnException(Thread.currentThread());
        FutureTask<ScriptPair> scriptFuture = new FutureTask<ScriptPair>(this.scriptRunner);
        try {
            new Thread(scriptFuture).start();
            try {
                this.latch.awaitPrepared();
            }
            catch (InterruptedException e) {
                if (this.latch.hasException()) {
                    throw this.latch.getException();
                }
                throw e;
            }
            try {
                this.statement.evaluate();
            }
            catch (Exception cause) {
                if (!this.latch.isFinished()) {
                    this.scriptRunner.abort();
                }
                ScriptPair scripts = null;
                Exception scriptFutureException = null;
                try {
                    scripts = scriptFuture.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    scriptFutureException = e;
                }
                if (cause instanceof AssumptionViolatedException) {
                    throw cause;
                }
                if (this.latch.hasException()) {
                    if (cause instanceof InterruptedException) {
                        throw this.latch.getException();
                    }
                    throw cause.initCause(this.latch.getException());
                }
                if (scriptFutureException != null) {
                    if (scriptFutureException instanceof ExecutionException) {
                        throw scriptFutureException.getCause().initCause(cause);
                    }
                    throw cause;
                }
                try {
                    Assert.assertEquals((String)"Specified behavior did not match", (Object)scripts.getExpectedScript(), (Object)scripts.getObservedScript());
                }
                catch (ComparisonFailure f) {
                    throw new MultipleFailureException(Arrays.asList(new Throwable[]{f, cause}));
                }
                throw cause;
            }
            String k3poSimpleName = K3poRule.class.getSimpleName();
            Assert.assertTrue((String)String.format("Did you instantiate %s with a @Rule and call %s.start() or %s.finish()?", k3poSimpleName, k3poSimpleName, k3poSimpleName), (boolean)this.latch.isStartable());
            ScriptPair scripts = scriptFuture.get();
            Assert.assertEquals((String)"Specified behavior did not match", (Object)scripts.getExpectedScript(), (Object)scripts.getObservedScript());
        }
        finally {
            try {
                this.scriptRunner.dispose();
            }
            finally {
                scriptFuture.cancel(true);
                Thread.interrupted();
            }
        }
    }

    public void awaitBarrier(String barrierName) throws Exception {
        this.scriptRunner.awaitBarrier(barrierName);
    }

    public void notifyBarrier(String barrierName) throws Exception {
        this.scriptRunner.notifyBarrier(barrierName);
    }
}

