/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.shaded.control.internal;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kaazing.k3po.junit.shaded.control.internal.command.AbortCommand;
import org.kaazing.k3po.junit.shaded.control.internal.command.AwaitCommand;
import org.kaazing.k3po.junit.shaded.control.internal.command.CloseCommand;
import org.kaazing.k3po.junit.shaded.control.internal.command.Command;
import org.kaazing.k3po.junit.shaded.control.internal.command.NotifyCommand;
import org.kaazing.k3po.junit.shaded.control.internal.command.PrepareCommand;
import org.kaazing.k3po.junit.shaded.control.internal.command.StartCommand;
import org.kaazing.k3po.junit.shaded.control.internal.event.CommandEvent;
import org.kaazing.k3po.junit.shaded.control.internal.event.ErrorEvent;
import org.kaazing.k3po.junit.shaded.control.internal.event.FinishedEvent;
import org.kaazing.k3po.junit.shaded.control.internal.event.NotifiedEvent;
import org.kaazing.k3po.junit.shaded.control.internal.event.PreparedEvent;
import org.kaazing.k3po.junit.shaded.control.internal.event.StartedEvent;

public final class Control {
    private static final int END_OF_STREAM = -1;
    private static final char END_OF_LINE = '\n';
    private static final String FINISHED_EVENT = "FINISHED";
    private static final String ERROR_EVENT = "ERROR";
    private static final String STARTED_EVENT = "STARTED";
    private static final String PREPARED_EVENT = "PREPARED";
    private static final String NOTIFIED_EVENT = "NOTIFIED";
    private static final Pattern HEADER_PATTERN = Pattern.compile("([a-z\\-]+):([^\n]+)");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final URL location;
    private URLConnection connection;
    private InputStream bytesIn;
    private ByteArrayOutputStream lineBuf;

    public Control(URL location) {
        this.location = location;
    }

    public void connect() throws Exception {
        URLConnection newConnection = this.location.openConnection();
        newConnection.connect();
        this.connection = newConnection;
        this.bytesIn = this.connection.getInputStream();
        this.lineBuf = new ByteArrayOutputStream();
    }

    public void disconnect() throws Exception {
        block9: {
            if (this.connection != null) {
                try {
                    if (this.connection instanceof Closeable) {
                        ((Closeable)((Object)this.connection)).close();
                        break block9;
                    }
                    try {
                        this.connection.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.connection.getOutputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public void writeCommand(Command command) throws Exception {
        this.checkConnected();
        switch (command.getKind()) {
            case PREPARE: {
                this.writeCommand((PrepareCommand)command);
                break;
            }
            case START: {
                this.writeCommand((StartCommand)command);
                break;
            }
            case ABORT: {
                this.writeCommand((AbortCommand)command);
                break;
            }
            case AWAIT: {
                this.writeCommand((AwaitCommand)command);
                break;
            }
            case NOTIFY: {
                this.writeCommand((NotifyCommand)command);
                break;
            }
            case CLOSE: {
                this.writeCommand((CloseCommand)command);
                break;
            }
            default: {
                throw new IllegalArgumentException("Urecognized command kind: " + (Object)((Object)command.getKind()));
            }
        }
    }

    public CommandEvent readEvent() throws Exception {
        return this.readEvent(0, TimeUnit.MILLISECONDS);
    }

    public CommandEvent readEvent(int timeout, TimeUnit unit) throws Exception {
        this.checkConnected();
        this.connection.setReadTimeout((int)unit.toMillis(timeout));
        CommandEvent event = null;
        String eventType = this.readLine();
        if (Thread.interrupted()) {
            throw new InterruptedException("thread interrupted during blocking read");
        }
        if (eventType != null) {
            switch (eventType) {
                case "PREPARED": {
                    event = this.readPreparedEvent();
                    break;
                }
                case "STARTED": {
                    event = this.readStartedEvent();
                    break;
                }
                case "ERROR": {
                    event = this.readErrorEvent();
                    break;
                }
                case "FINISHED": {
                    event = this.readFinishedEvent();
                    break;
                }
                case "NOTIFIED": {
                    event = this.readNotifiedEvent();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid protocol frame: " + eventType);
                }
            }
        }
        return event;
    }

    private void checkConnected() throws Exception {
        if (this.connection == null) {
            throw new IllegalStateException("Not connected");
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    private void writeCommand(PrepareCommand prepare) throws Exception {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        List<String> names = prepare.getNames();
        List<String> overriddenScriptProperties = prepare.getOverriddenScriptProperties();
        int contentLength = 0;
        StringBuilder content = new StringBuilder();
        if (overriddenScriptProperties != null) {
            for (String property : overriddenScriptProperties) {
                content.append(String.format("property %s\n", property));
            }
            contentLength = content.length();
        }
        ((Writer)textOut).append("PREPARE\n");
        ((Writer)textOut).append("version:2.0\n");
        ((Writer)textOut).append(String.format("content-length:%s\n", contentLength));
        for (String name : names) {
            ((Writer)textOut).append(String.format("name:%s\n", name));
        }
        ((Writer)textOut).append("\n");
        ((Writer)textOut).append(content.toString());
        ((Writer)textOut).flush();
    }

    private void writeCommand(StartCommand start) throws Exception {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("START\n");
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(AbortCommand abort) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("ABORT\n");
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(NotifyCommand notify) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("NOTIFY\n");
        ((Writer)textOut).append(String.format("barrier:%s\n", notify.getBarrier()));
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(AwaitCommand await) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("AWAIT\n");
        ((Writer)textOut).append(String.format("barrier:%s\n", await.getBarrier()));
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(CloseCommand close) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("CLOSE\n");
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private PreparedEvent readPreparedEvent() throws IOException {
        String line;
        PreparedEvent prepared = new PreparedEvent();
        int length = -1;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
                case "barrier": {
                    prepared.getBarriers().add(headerValue);
                    break;
                }
            }
        } while (!line.isEmpty());
        if (length >= 0) {
            prepared.setScript(this.readContent(length));
        }
        return prepared;
    }

    private StartedEvent readStartedEvent() throws IOException {
        String line;
        StartedEvent started = new StartedEvent();
        do {
            String headerName;
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.readLine())).matches()) continue;
            switch (headerName = matcher.group(1)) {
                case "name": {
                    break;
                }
            }
        } while (!line.isEmpty());
        return started;
    }

    private FinishedEvent readFinishedEvent() throws IOException {
        String line;
        FinishedEvent finished = new FinishedEvent();
        int length = -1;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
                case "notified": {
                    finished.getCompletedBarriers().add(headerValue);
                    break;
                }
                case "awaiting": {
                    finished.getIncompleteBarriers().add(headerValue);
                    break;
                }
            }
        } while (!line.isEmpty());
        if (length >= 0) {
            finished.setScript(this.readContent(length));
        }
        return finished;
    }

    private NotifiedEvent readNotifiedEvent() throws IOException {
        String line;
        NotifiedEvent notified = new NotifiedEvent();
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "barrier": {
                    notified.setBarrier(headerValue);
                    break;
                }
            }
        } while (!line.isEmpty());
        return notified;
    }

    private ErrorEvent readErrorEvent() throws IOException {
        String line;
        ErrorEvent error = new ErrorEvent();
        int length = 0;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "summary": {
                    error.setSummary(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
            }
        } while (!line.isEmpty());
        if (length > 0) {
            error.setDescription(this.readContent(length));
        }
        return error;
    }

    private String readContent(int length) throws IOException {
        int result;
        byte[] content = new byte[length];
        int bytesRead = 0;
        do {
            if ((result = this.bytesIn.read(content, bytesRead, length - bytesRead)) != -1) continue;
            throw new EOFException("EOF detected before all content read");
        } while ((bytesRead += result) != length);
        return new String(content, "UTF-8");
    }

    private String readLine() throws IOException {
        this.lineBuf.reset();
        int b = this.bytesIn.read();
        while (b != -1 && b != 10) {
            this.lineBuf.write(b);
            b = this.bytesIn.read();
        }
        String line = null;
        if (this.lineBuf.size() != 0 || b != -1) {
            line = this.lineBuf.toString("UTF-8");
        }
        return line;
    }

    public void notifyBarrier(String barrierName) throws Exception {
        NotifyCommand notifyCommand = new NotifyCommand();
        notifyCommand.setBarrier(barrierName);
        this.writeCommand(notifyCommand);
    }

    public void sendAwaitBarrier(String barrierName) throws Exception {
        AwaitCommand awaitCommand = new AwaitCommand();
        awaitCommand.setBarrier(barrierName);
        this.writeCommand(awaitCommand);
    }
}

