/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kaazing.k3po.lang.internal.ast.AstAcceptableNode;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.AstStreamNode;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public class AstAcceptNode
extends AstStreamNode {
    private String acceptName;
    private String notifyName;
    private Map<String, Object> options;
    private List<AstAcceptableNode> acceptables;
    private AstValue<URI> location;

    public AstAcceptNode() {
    }

    public AstAcceptNode(AstAcceptNode acceptNode) {
        this.regionInfo = acceptNode.regionInfo;
        this.location = acceptNode.location;
        this.acceptName = acceptNode.acceptName;
        this.notifyName = acceptNode.notifyName;
        this.options = acceptNode.options;
    }

    public AstValue<URI> getLocation() {
        return this.location;
    }

    public void setLocation(AstValue<URI> location) {
        this.location = location;
    }

    public String getAcceptName() {
        return this.acceptName;
    }

    public void setAcceptName(String acceptName) {
        this.acceptName = acceptName;
    }

    public String getNotifyName() {
        return this.notifyName;
    }

    public void setNotifyName(String notifyName) {
        this.notifyName = notifyName;
    }

    public Map<String, Object> getOptions() {
        if (this.options == null) {
            this.options = new LinkedHashMap<String, Object>();
        }
        return this.options;
    }

    public List<AstAcceptableNode> getAcceptables() {
        if (this.acceptables == null) {
            this.acceptables = new LinkedList<AstAcceptableNode>();
        }
        return this.acceptables;
    }

    @Override
    protected int hashTo() {
        int hashCode = super.hashTo();
        if (this.location != null) {
            hashCode <<= 4;
            hashCode ^= this.location.hashCode();
        }
        if (this.options != null) {
            hashCode <<= 4;
            hashCode ^= this.options.hashCode();
        }
        if (this.acceptName != null) {
            hashCode <<= 4;
            hashCode ^= this.acceptName.hashCode();
        }
        if (this.notifyName != null) {
            hashCode <<= 4;
            hashCode ^= this.notifyName.hashCode();
        }
        if (this.acceptables != null) {
            hashCode <<= 4;
            hashCode ^= this.acceptables.hashCode();
        }
        return hashCode;
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstAcceptNode && this.equalTo((AstAcceptNode)that);
    }

    protected boolean equalTo(AstAcceptNode that) {
        return super.equalTo(that) && AstUtil.equivalent(this.location, that.location) && AstUtil.equivalent(this.options, that.options) && AstUtil.equivalent(this.acceptName, that.acceptName) && AstUtil.equivalent(this.acceptables, that.acceptables);
    }

    @Override
    public <R, P> R accept(AstNode.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected void describe(StringBuilder buf) {
        super.describe(buf);
        if (this.acceptables != null) {
            for (AstAcceptableNode acceptable : this.acceptables) {
                acceptable.describe(buf);
            }
        }
    }

    @Override
    protected void describeLine(StringBuilder sb) {
        super.describeLine(sb);
        sb.append("accept ").append(this.location);
        if (this.acceptName != null) {
            sb.append(" as ").append(this.acceptName);
        }
        sb.append('\n');
        if (this.options != null) {
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                sb.append("        option ").append(entry.getKey()).append(" ").append(entry.getValue()).append('\n');
            }
        }
    }
}

