/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.AstStreamNode;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public class AstConnectNode
extends AstStreamNode {
    private Map<String, Object> options;
    private String awaitName;
    private AstValue<URI> location;

    public AstConnectNode() {
    }

    public AstConnectNode(AstConnectNode connectNode) {
        this.regionInfo = connectNode.regionInfo;
        this.location = connectNode.location;
        this.awaitName = connectNode.awaitName;
        this.options = connectNode.options;
    }

    public String getAwaitName() {
        return this.awaitName;
    }

    public void setAwaitName(String awaitName) {
        this.awaitName = awaitName;
    }

    public AstValue<URI> getLocation() {
        return this.location;
    }

    public void setLocation(AstValue<URI> location) {
        this.location = location;
    }

    public Map<String, Object> getOptions() {
        if (this.options == null) {
            this.options = new LinkedHashMap<String, Object>();
        }
        return this.options;
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        if (this.location != null) {
            hashCode <<= 4;
            hashCode ^= this.location.hashCode();
        }
        if (this.options != null) {
            hashCode <<= 4;
            hashCode ^= this.options.hashCode();
        }
        if (this.awaitName != null) {
            hashCode <<= 4;
            hashCode ^= this.awaitName.hashCode();
        }
        return hashCode;
    }

    @Override
    public <R, P> R accept(AstNode.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstConnectNode && this.equalTo((AstConnectNode)that);
    }

    protected boolean equalTo(AstConnectNode that) {
        return super.equalTo(that) && AstUtil.equivalent(this.location, that.location) && AstUtil.equivalent(this.options, that.options);
    }

    @Override
    protected void describeLine(StringBuilder sb) {
        super.describeLine(sb);
        sb.append("connect ");
        if (this.awaitName != null) {
            sb.append("await ").append(this.awaitName).append("\n        ");
        }
        sb.append(this.location).append('\n');
        if (this.options != null) {
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                sb.append("        option ").append(entry.getKey()).append(" ").append(entry.getValue()).append('\n');
            }
        }
    }
}

