/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast;

import javax.el.ELContext;
import javax.el.ELResolver;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;

public class AstPropertyNode
extends AstNode {
    private String propertyName;
    private AstValue<?> propertyValue;
    private ExpressionContext environment;

    @Override
    public <R, P> R accept(AstNode.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    public void setEnvironment(ExpressionContext environment) {
        this.environment = environment;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public AstValue<?> getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(AstValue<?> propertyValue) {
        this.propertyValue = propertyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolve() {
        Object value = this.propertyValue.getValue();
        ELResolver resolver = this.environment.getELResolver();
        ExpressionContext expressionContext = this.environment;
        synchronized (expressionContext) {
            resolver.setValue((ELContext)this.environment, null, (Object)this.propertyName, value);
        }
        return value;
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        if (this.propertyName != null) {
            hashCode <<= 4;
            hashCode ^= this.propertyName.hashCode();
        }
        if (this.propertyValue != null) {
            hashCode <<= 4;
            hashCode ^= this.propertyValue.hashCode();
        }
        return hashCode;
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstPropertyNode && this.equalTo((AstPropertyNode)that);
    }

    protected boolean equalTo(AstPropertyNode that) {
        return AstUtil.equivalent(this.propertyName, that.propertyName) && AstUtil.equivalent(this.propertyValue, that.propertyValue);
    }

    @Override
    protected void describe(StringBuilder buf) {
        super.describe(buf);
        buf.append(String.format("property %s %s\n", this.getPropertyName(), this.getPropertyValue()));
    }

    public ExpressionContext getExpressionContext() {
        return this.environment;
    }
}

