/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.builder;

import javax.el.ValueExpression;
import org.kaazing.k3po.lang.internal.ast.AstReadValueNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamableNode;
import org.kaazing.k3po.lang.internal.ast.builder.AbstractAstNodeBuilder;
import org.kaazing.k3po.lang.internal.ast.builder.AbstractAstStreamableNodeBuilder;
import org.kaazing.k3po.lang.internal.ast.matcher.AstExactBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstExactTextMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstExpressionMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstFixedLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstNumberMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstRegexMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstVariableLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;
import org.kaazing.k3po.lang.internal.regex.NamedGroupPattern;

public class AstReadNodeBuilder
extends AbstractAstStreamableNodeBuilder<AstReadValueNode, AstReadValueNode> {
    public AstReadNodeBuilder() {
        this(new AstReadValueNode());
    }

    public AstReadNodeBuilder addExactBytes(byte[] exactBytes, ExpressionContext environment) {
        ((AstReadValueNode)this.node).addMatcher(new AstExactBytesMatcher(exactBytes));
        return this;
    }

    public AstReadNodeBuilder addExactText(String exactText) {
        ((AstReadValueNode)this.node).addMatcher(new AstExactTextMatcher(exactText));
        return this;
    }

    public AstReadNodeBuilder addNumber(Number number) {
        ((AstReadValueNode)this.node).addMatcher(new AstNumberMatcher(number));
        return this;
    }

    public AstReadNodeBuilder addExpression(ValueExpression value, ExpressionContext environment) {
        ((AstReadValueNode)this.node).addMatcher(new AstExpressionMatcher(value, environment));
        return this;
    }

    public AstReadNodeBuilder addFixedLengthBytes(int length) {
        ((AstReadValueNode)this.node).addMatcher(new AstFixedLengthBytesMatcher(length));
        return this;
    }

    public AstReadNodeBuilder addFixedLengthBytes(int length, String captureName, ExpressionContext environment) {
        ((AstReadValueNode)this.node).addMatcher(new AstFixedLengthBytesMatcher(length, captureName, environment));
        return this;
    }

    public AstReadNodeBuilder addRegex(NamedGroupPattern pattern, ExpressionContext environment) {
        ((AstReadValueNode)this.node).addMatcher(new AstRegexMatcher(pattern, environment));
        return this;
    }

    public AstReadNodeBuilder addVariableLengthBytes(ValueExpression length, ExpressionContext environment) {
        ((AstReadValueNode)this.node).addMatcher(new AstVariableLengthBytesMatcher(length, environment));
        return this;
    }

    public AstReadNodeBuilder addVariableLengthBytes(ValueExpression length, String captureName, ExpressionContext environment) {
        ((AstReadValueNode)this.node).addMatcher(new AstVariableLengthBytesMatcher(length, captureName, environment));
        return this;
    }

    @Override
    public AstReadValueNode done() {
        return (AstReadValueNode)this.result;
    }

    private AstReadNodeBuilder(AstReadValueNode node) {
        super(node, node);
    }

    public static class StreamNested<R extends AbstractAstNodeBuilder<? extends AstStreamNode, ?>>
    extends AbstractAstStreamableNodeBuilder<AstReadValueNode, R> {
        public StreamNested(R builder) {
            super(new AstReadValueNode(), builder);
        }

        public StreamNested<R> addExactBytes(byte[] exactBytes, ExpressionContext environment) {
            ((AstReadValueNode)this.node).addMatcher(new AstExactBytesMatcher(exactBytes));
            return this;
        }

        public StreamNested<R> addExactText(String exactText) {
            ((AstReadValueNode)this.node).addMatcher(new AstExactTextMatcher(exactText));
            return this;
        }

        public StreamNested<R> addExpression(ValueExpression value, ExpressionContext environment) {
            ((AstReadValueNode)this.node).addMatcher(new AstExpressionMatcher(value, environment));
            return this;
        }

        public StreamNested<R> addFixedLengthBytes(int length) {
            ((AstReadValueNode)this.node).addMatcher(new AstFixedLengthBytesMatcher(length));
            return this;
        }

        public StreamNested<R> addFixedLengthBytes(int length, String captureName, ExpressionContext environment) {
            ((AstReadValueNode)this.node).addMatcher(new AstFixedLengthBytesMatcher(length, captureName, environment));
            return this;
        }

        public StreamNested<R> addRegex(NamedGroupPattern pattern, ExpressionContext environment) {
            ((AstReadValueNode)this.node).addMatcher(new AstRegexMatcher(pattern, environment));
            return this;
        }

        public StreamNested<R> addVariableLengthBytes(ValueExpression length, ExpressionContext environment) {
            ((AstReadValueNode)this.node).addMatcher(new AstVariableLengthBytesMatcher(length, environment));
            return this;
        }

        public StreamNested<R> addVariableLengthBytes(ValueExpression length, String captureName, ExpressionContext environment) {
            ((AstReadValueNode)this.node).addMatcher(new AstVariableLengthBytesMatcher(length, captureName, environment));
            return this;
        }

        @Override
        public R done() {
            AstStreamNode streamNode = (AstStreamNode)((AbstractAstNodeBuilder)this.result).node;
            streamNode.getStreamables().add((AstStreamableNode)this.node);
            return (R)((AbstractAstNodeBuilder)this.result);
        }
    }
}

