/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.matcher;

import java.util.Arrays;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;

public final class AstExactBytesMatcher
extends AstValueMatcher {
    private final byte[] value;

    public AstExactBytesMatcher(byte[] value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValueMatcher.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return Arrays.hashCode(this.value);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstExactBytesMatcher && this.equalTo((AstExactBytesMatcher)that);
    }

    protected boolean equalTo(AstExactBytesMatcher that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        if (this.value == null || this.value.length == 0) {
            buf.append("[]");
        } else {
            for (byte b : this.value) {
                buf.append(String.format(" 0x%02x", b));
            }
            buf.setCharAt(0, '[');
            buf.append(']');
        }
    }
}

