/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.matcher;

import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;

public class AstFixedLengthBytesMatcher
extends AstValueMatcher {
    private final int length;
    private final String captureName;
    private final ExpressionContext environment;

    public AstFixedLengthBytesMatcher(int length) {
        this(length, null, null);
    }

    public AstFixedLengthBytesMatcher(int length, String captureName, ExpressionContext environment) {
        this.length = length;
        this.captureName = captureName;
        this.environment = environment;
    }

    public int getLength() {
        return this.length;
    }

    public String getCaptureName() {
        return this.captureName;
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        hashCode <<= 4;
        hashCode ^= this.length;
        if (this.captureName != null) {
            hashCode <<= 4;
            hashCode ^= this.captureName.hashCode();
        }
        return hashCode;
    }

    @Override
    public <R, P> R accept(AstValueMatcher.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstFixedLengthBytesMatcher && this.equalTo((AstFixedLengthBytesMatcher)that);
    }

    protected boolean equalTo(AstFixedLengthBytesMatcher that) {
        return AstUtil.equivalent(this.length, that.length) && AstUtil.equivalent(this.captureName, that.captureName);
    }

    @Override
    protected void describe(StringBuilder buf) {
        if (this.captureName != null) {
            buf.append(String.format("([0..%d}]:%s)", this.length, this.captureName));
        } else {
            buf.append(String.format("[0..%d}]", this.length));
        }
    }

    public ExpressionContext getEnvironment() {
        return this.environment;
    }
}

