/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.matcher;

import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;
import org.kaazing.k3po.lang.internal.regex.NamedGroupPattern;

public class AstRegexMatcher
extends AstValueMatcher {
    private final NamedGroupPattern pattern;
    private final ExpressionContext environment;

    public AstRegexMatcher(NamedGroupPattern pattern, ExpressionContext environment) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        this.pattern = pattern;
        this.environment = environment;
    }

    public NamedGroupPattern getValue() {
        return this.pattern;
    }

    @Override
    protected int hashTo() {
        return this.pattern.hashCode();
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstRegexMatcher && this.equalTo((AstRegexMatcher)that);
    }

    protected boolean equalTo(AstRegexMatcher that) {
        return AstUtil.equivalent(this.pattern, that.pattern);
    }

    @Override
    public <R, P> R accept(AstValueMatcher.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append('/').append(this.pattern.toString()).append('/');
    }

    public ExpressionContext getEnvironment() {
        return this.environment;
    }
}

