/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.matcher;

import javax.el.ValueExpression;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;

public class AstVariableLengthBytesMatcher
extends AstValueMatcher {
    private final ValueExpression length;
    private final String captureName;
    private final ExpressionContext environment;

    public AstVariableLengthBytesMatcher(ValueExpression length, ExpressionContext environment) {
        this(length, null, environment);
    }

    public AstVariableLengthBytesMatcher(ValueExpression length, String captureName, ExpressionContext environment) {
        this.length = length;
        this.captureName = captureName;
        this.environment = environment;
    }

    public ValueExpression getLength() {
        return this.length;
    }

    public String getCaptureName() {
        return this.captureName;
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        if (this.length != null) {
            hashCode <<= 4;
            hashCode ^= this.length.hashCode();
        }
        if (this.captureName != null) {
            hashCode <<= 4;
            hashCode ^= this.captureName.hashCode();
        }
        return hashCode;
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstVariableLengthBytesMatcher && this.equalTo((AstVariableLengthBytesMatcher)that);
    }

    protected boolean equalTo(AstVariableLengthBytesMatcher that) {
        return AstUtil.equivalent(this.length, that.length) && AstUtil.equivalent(this.captureName, that.captureName);
    }

    @Override
    public <R, P> R accept(AstValueMatcher.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected void describe(StringBuilder buf) {
        if (this.captureName != null) {
            buf.append(String.format("([0..%s]:%s)", this.length.getExpressionString(), this.captureName));
        } else {
            buf.append(String.format("[0..%s]", this.length.getExpressionString()));
        }
    }

    public ExpressionContext getEnvironment() {
        return this.environment;
    }
}

