/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.value;

import java.util.Objects;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public final class AstLiteralIntegerValue
extends AstValue<Integer> {
    private final int value;

    public AstLiteralIntegerValue(Integer value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValue.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return Integer.hashCode(this.value);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstLiteralIntegerValue && this.equalTo((AstLiteralIntegerValue)that);
    }

    protected boolean equalTo(AstLiteralIntegerValue that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append(Integer.toString(this.value));
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }
}

