/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.value;

import java.util.Objects;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public final class AstLiteralLongValue
extends AstValue<Long> {
    private final long value;

    public AstLiteralLongValue(Long value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValue.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return Long.hashCode(this.value);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstLiteralLongValue && this.equalTo((AstLiteralLongValue)that);
    }

    protected boolean equalTo(AstLiteralLongValue that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append(Long.toString(this.value));
        buf.append('L');
    }

    public static String toString(long value) {
        return Long.toString(value);
    }
}

