/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.parser;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.AstAcceptNode;
import org.kaazing.k3po.lang.internal.ast.AstAcceptedNode;
import org.kaazing.k3po.lang.internal.ast.AstBarrierNode;
import org.kaazing.k3po.lang.internal.ast.AstBoundNode;
import org.kaazing.k3po.lang.internal.ast.AstChildClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstChildOpenedNode;
import org.kaazing.k3po.lang.internal.ast.AstCloseNode;
import org.kaazing.k3po.lang.internal.ast.AstClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstCommandNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectNode;
import org.kaazing.k3po.lang.internal.ast.AstConnectedNode;
import org.kaazing.k3po.lang.internal.ast.AstDisconnectNode;
import org.kaazing.k3po.lang.internal.ast.AstDisconnectedNode;
import org.kaazing.k3po.lang.internal.ast.AstEventNode;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstOpenedNode;
import org.kaazing.k3po.lang.internal.ast.AstPropertyNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadAwaitNode;
import org.kaazing.k3po.lang.internal.ast.AstReadClosedNode;
import org.kaazing.k3po.lang.internal.ast.AstReadConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstReadNotifyNode;
import org.kaazing.k3po.lang.internal.ast.AstReadOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstReadValueNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.AstRejectedNode;
import org.kaazing.k3po.lang.internal.ast.AstScriptNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamNode;
import org.kaazing.k3po.lang.internal.ast.AstStreamableNode;
import org.kaazing.k3po.lang.internal.ast.AstUnbindNode;
import org.kaazing.k3po.lang.internal.ast.AstUnboundNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAbortNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAbortedNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteAwaitNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteCloseNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteConfigNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteFlushNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteNotifyNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteOptionNode;
import org.kaazing.k3po.lang.internal.ast.AstWriteValueNode;
import org.kaazing.k3po.lang.internal.ast.matcher.AstByteLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstExactBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstExactTextMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstExpressionMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstFixedLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstIntLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstLongLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstNumberMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstRegexMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstShortLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.matcher.AstVariableLengthBytesMatcher;
import org.kaazing.k3po.lang.internal.ast.value.AstExpressionValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralByteValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralBytesValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralIntegerValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralLongValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralShortValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralTextValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralURIValue;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;
import org.kaazing.k3po.lang.internal.parser.ParserHelper;
import org.kaazing.k3po.lang.internal.parser.types.TypeSystem;
import org.kaazing.k3po.lang.internal.regex.NamedGroupPattern;
import org.kaazing.k3po.lang.parser.v2.RobotBaseVisitor;
import org.kaazing.k3po.lang.parser.v2.RobotParser;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;

public abstract class ScriptParseStrategy<T extends AstRegion> {
    public static final ScriptParseStrategy<AstScriptNode> SCRIPT = new ScriptParseStrategy<AstScriptNode>(){

        @Override
        public AstScriptNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstScriptNode)new AstScriptNodeVisitor(factory, environment).visit((ParseTree)parser.scriptNode());
        }
    };
    public static final ScriptParseStrategy<AstPropertyNode> PROPERTY_NODE = new ScriptParseStrategy<AstPropertyNode>(){

        @Override
        public AstPropertyNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstPropertyNode)new AstPropertyNodeVisitor(factory, environment).visit((ParseTree)parser.propertyNode());
        }
    };
    public static final ScriptParseStrategy<AstStreamNode> STREAM = new ScriptParseStrategy<AstStreamNode>(){

        @Override
        public AstStreamNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstStreamNode)new AstStreamNodeVisitor(factory, environment).visit((ParseTree)parser.streamNode());
        }
    };
    public static final ScriptParseStrategy<AstStreamableNode> STREAMABLE = new ScriptParseStrategy<AstStreamableNode>(){

        @Override
        public AstStreamableNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstStreamableNode)new AstStreamableNodeVisitor(factory, environment).visit((ParseTree)parser.streamableNode());
        }
    };
    public static final ScriptParseStrategy<AstEventNode> EVENT = new ScriptParseStrategy<AstEventNode>(){

        @Override
        public AstEventNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstEventNode)new AstEventNodeVisitor(factory, environment).visit((ParseTree)parser.eventNode());
        }
    };
    public static final ScriptParseStrategy<AstCommandNode> COMMAND = new ScriptParseStrategy<AstCommandNode>(){

        @Override
        public AstCommandNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstCommandNode)new AstCommandNodeVisitor(factory, environment).visit((ParseTree)parser.commandNode());
        }
    };
    public static final ScriptParseStrategy<AstBarrierNode> BARRIER = new ScriptParseStrategy<AstBarrierNode>(){

        @Override
        public AstBarrierNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstBarrierNode)new AstBarrierNodeVisitor(factory, environment).visit((ParseTree)parser.barrierNode());
        }
    };
    public static final ScriptParseStrategy<AstStreamableNode> SERVER_STREAMABLE = new ScriptParseStrategy<AstStreamableNode>(){

        @Override
        public AstStreamableNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstStreamableNode)new AstStreamableNodeVisitor(factory, environment).visit((ParseTree)parser.serverStreamableNode());
        }
    };
    public static final ScriptParseStrategy<AstEventNode> SERVER_EVENT = new ScriptParseStrategy<AstEventNode>(){

        @Override
        public AstEventNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstEventNode)new AstEventNodeVisitor(factory, environment).visit((ParseTree)parser.serverEventNode());
        }
    };
    public static final ScriptParseStrategy<AstCommandNode> SERVER_COMMAND = new ScriptParseStrategy<AstCommandNode>(){

        @Override
        public AstCommandNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstCommandNode)new AstCommandNodeVisitor(factory, environment).visit((ParseTree)parser.serverCommandNode());
        }
    };
    public static final ScriptParseStrategy<AstAcceptNode> ACCEPT = new ScriptParseStrategy<AstAcceptNode>(){

        @Override
        public AstAcceptNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstAcceptNode)new AstAcceptNodeVisitor(factory, environment).visit((ParseTree)parser.acceptNode());
        }
    };
    public static final ScriptParseStrategy<AstAcceptedNode> ACCEPTED = new ScriptParseStrategy<AstAcceptedNode>(){

        @Override
        public AstAcceptedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstAcceptedNode)new AstAcceptedNodeVisitor(factory, environment).visit((ParseTree)parser.acceptedNode());
        }
    };
    public static final ScriptParseStrategy<AstRejectedNode> REJECTED = new ScriptParseStrategy<AstRejectedNode>(){

        @Override
        public AstRejectedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstRejectedNode)new AstRejectedNodeVisitor(factory, environment).visit((ParseTree)parser.rejectedNode());
        }
    };
    public static final ScriptParseStrategy<AstConnectNode> CONNECT = new ScriptParseStrategy<AstConnectNode>(){

        @Override
        public AstConnectNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstConnectNode)new AstConnectNodeVisitor(factory, environment).visit((ParseTree)parser.connectNode());
        }
    };
    public static final ScriptParseStrategy<AstConnectAbortNode> CONNECT_ABORT = new ScriptParseStrategy<AstConnectAbortNode>(){

        @Override
        public AstConnectAbortNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstConnectAbortNode)new AstConnectAbortNodeVisitor(factory, environment).visit((ParseTree)parser.connectAbortNode());
        }
    };
    public static final ScriptParseStrategy<AstConnectAbortedNode> CONNECT_ABORTED = new ScriptParseStrategy<AstConnectAbortedNode>(){

        @Override
        public AstConnectAbortedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstConnectAbortedNode)new AstConnectAbortedNodeVisitor(factory, environment).visit((ParseTree)parser.connectAbortedNode());
        }
    };
    public static final ScriptParseStrategy<AstCloseNode> CLOSE = new ScriptParseStrategy<AstCloseNode>(){

        @Override
        public AstCloseNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            AstCloseNodeVisitor astCloseNodeVisitor = new AstCloseNodeVisitor(factory, environment);
            return (AstCloseNode)astCloseNodeVisitor.visit((ParseTree)parser.closeNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteAbortNode> WRITE_ABORT = new ScriptParseStrategy<AstWriteAbortNode>(){

        @Override
        public AstWriteAbortNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteAbortNode)new AstWriteAbortNodeVisitor(factory, environment).visit((ParseTree)parser.writeAbortNode());
        }
    };
    public static final ScriptParseStrategy<AstReadAbortNode> READ_ABORT = new ScriptParseStrategy<AstReadAbortNode>(){

        @Override
        public AstReadAbortNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadAbortNode)new AstReadAbortNodeVisitor(factory, environment).visit((ParseTree)parser.readAbortNode());
        }
    };
    public static final ScriptParseStrategy<AstDisconnectNode> DISCONNECT = new ScriptParseStrategy<AstDisconnectNode>(){

        @Override
        public AstDisconnectNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstDisconnectNode)new AstDisconnectNodeVisitor(factory, environment).visit((ParseTree)parser.disconnectNode());
        }
    };
    public static final ScriptParseStrategy<AstUnbindNode> UNBIND = new ScriptParseStrategy<AstUnbindNode>(){

        @Override
        public AstUnbindNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstUnbindNode)new AstUnbindNodeVisitor(factory, environment).visit((ParseTree)parser.unbindNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteValueNode> WRITE = new ScriptParseStrategy<AstWriteValueNode>(){

        @Override
        public AstWriteValueNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteValueNode)new AstWriteValueNodeVisitor(factory, environment).visit((ParseTree)parser.writeNode());
        }
    };
    public static final ScriptParseStrategy<AstChildOpenedNode> CHILD_OPENED = new ScriptParseStrategy<AstChildOpenedNode>(){

        @Override
        public AstChildOpenedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstChildOpenedNode)new AstChildOpenedNodeVisitor(factory, environment).visit((ParseTree)parser.childOpenedNode());
        }
    };
    public static final ScriptParseStrategy<AstChildClosedNode> CHILD_CLOSED = new ScriptParseStrategy<AstChildClosedNode>(){

        @Override
        public AstChildClosedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstChildClosedNode)new AstChildClosedNodeVisitor(factory, environment).visit((ParseTree)parser.childClosedNode());
        }
    };
    public static final ScriptParseStrategy<AstBoundNode> BOUND = new ScriptParseStrategy<AstBoundNode>(){

        @Override
        public AstBoundNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstBoundNode)new AstBoundNodeVisitor(factory, environment).visit((ParseTree)parser.boundNode());
        }
    };
    public static final ScriptParseStrategy<AstClosedNode> CLOSED = new ScriptParseStrategy<AstClosedNode>(){

        @Override
        public AstClosedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstClosedNode)new AstClosedNodeVisitor(factory, environment).visit((ParseTree)parser.closedNode());
        }
    };
    public static final ScriptParseStrategy<AstReadAbortedNode> READ_ABORTED = new ScriptParseStrategy<AstReadAbortedNode>(){

        @Override
        public AstReadAbortedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadAbortedNode)new AstReadAbortedNodeVisitor(factory, environment).visit((ParseTree)parser.readAbortedNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteAbortedNode> WRITE_ABORTED = new ScriptParseStrategy<AstWriteAbortedNode>(){

        @Override
        public AstWriteAbortedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteAbortedNode)new AstWriteAbortedNodeVisitor(factory, environment).visit((ParseTree)parser.writeAbortedNode());
        }
    };
    public static final ScriptParseStrategy<AstConnectedNode> CONNECTED = new ScriptParseStrategy<AstConnectedNode>(){

        @Override
        public AstConnectedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstConnectedNode)new AstConnectedNodeVisitor(factory, environment).visit((ParseTree)parser.connectedNode());
        }
    };
    public static final ScriptParseStrategy<AstDisconnectedNode> DISCONNECTED = new ScriptParseStrategy<AstDisconnectedNode>(){

        @Override
        public AstDisconnectedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstDisconnectedNode)new AstDisconnectedNodeVisitor(factory, environment).visit((ParseTree)parser.disconnectedNode());
        }
    };
    public static final ScriptParseStrategy<AstOpenedNode> OPENED = new ScriptParseStrategy<AstOpenedNode>(){

        @Override
        public AstOpenedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstOpenedNode)new AstOpenedNodeVisitor(factory, environment).visit((ParseTree)parser.openedNode());
        }
    };
    public static final ScriptParseStrategy<AstReadValueNode> READ = new ScriptParseStrategy<AstReadValueNode>(){

        @Override
        public AstReadValueNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadValueNode)new AstReadValueNodeVisitor(factory, environment).visit((ParseTree)parser.readNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteFlushNode> WRITE_FLUSH = new ScriptParseStrategy<AstWriteFlushNode>(){

        @Override
        public AstWriteFlushNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteFlushNode)new AstWriteFlushNodeVisitor(factory, environment).visit((ParseTree)parser.writeFlushNode());
        }
    };
    public static final ScriptParseStrategy<AstReadClosedNode> READ_CLOSED = new ScriptParseStrategy<AstReadClosedNode>(){

        @Override
        public AstReadClosedNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadClosedNode)new AstReadClosedNodeVisitor(factory, environment).visit((ParseTree)parser.readClosedNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteCloseNode> WRITE_CLOSE = new ScriptParseStrategy<AstWriteCloseNode>(){

        @Override
        public AstWriteCloseNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteCloseNode)new AstWriteCloseNodeVisitor(factory, environment).visit((ParseTree)parser.writeCloseNode());
        }
    };
    public static final ScriptParseStrategy<AstUnboundNode> UNBOUND = new ScriptParseStrategy<AstUnboundNode>(){

        @Override
        public AstUnboundNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstUnboundNode)new AstUnboundNodeVisitor(factory, environment).visit((ParseTree)parser.unboundNode());
        }
    };
    public static final ScriptParseStrategy<AstReadAwaitNode> READ_AWAIT = new ScriptParseStrategy<AstReadAwaitNode>(){

        @Override
        public AstReadAwaitNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadAwaitNode)new AstReadAwaitNodeVisitor(factory, environment).visit((ParseTree)parser.readAwaitNode());
        }
    };
    public static final ScriptParseStrategy<AstReadNotifyNode> READ_NOTIFY = new ScriptParseStrategy<AstReadNotifyNode>(){

        @Override
        public AstReadNotifyNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadNotifyNode)new AstReadNotifyNodeVisitor(factory, environment).visit((ParseTree)parser.readNotifyNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteAwaitNode> WRITE_AWAIT = new ScriptParseStrategy<AstWriteAwaitNode>(){

        @Override
        public AstWriteAwaitNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteAwaitNode)new AstWriteAwaitNodeVisitor(factory, environment).visit((ParseTree)parser.writeAwaitNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteNotifyNode> WRITE_NOTIFY = new ScriptParseStrategy<AstWriteNotifyNode>(){

        @Override
        public AstWriteNotifyNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteNotifyNode)new AstWriteNotifyNodeVisitor(factory, environment).visit((ParseTree)parser.writeNotifyNode());
        }
    };
    public static final ScriptParseStrategy<AstValueMatcher> MATCHER = new ScriptParseStrategy<AstValueMatcher>(){

        @Override
        public AstValueMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstValueMatcher)new AstValueMatcherVisitor(factory, environment).visit((ParseTree)parser.matcher());
        }
    };
    public static final ScriptParseStrategy<AstExactTextMatcher> EXACT_TEXT_MATCHER = new ScriptParseStrategy<AstExactTextMatcher>(){

        @Override
        public AstExactTextMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstExactTextMatcher)new AstExactTextMatcherVisitor(factory, environment).visit((ParseTree)parser.exactTextMatcher());
        }
    };
    public static final ScriptParseStrategy<AstExactBytesMatcher> EXACT_BYTES_MATCHER = new ScriptParseStrategy<AstExactBytesMatcher>(){

        @Override
        public AstExactBytesMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstExactBytesMatcher)new AstExactBytesMatcherVisitor(factory, environment).visit((ParseTree)parser.exactBytesMatcher());
        }
    };
    public static final ScriptParseStrategy<AstNumberMatcher> NUMBER_MATCHER = new ScriptParseStrategy<AstNumberMatcher>(){

        @Override
        public AstNumberMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstNumberMatcher)new AstNumberMatcherVisitor(factory, environment).visit((ParseTree)parser.numberMatcher());
        }
    };
    public static final ScriptParseStrategy<AstRegexMatcher> REGEX_MATCHER = new ScriptParseStrategy<AstRegexMatcher>(){

        @Override
        public AstRegexMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstRegexMatcher)new AstRegexMatcherVisitor(factory, environment).visit((ParseTree)parser.regexMatcher());
        }
    };
    public static final ScriptParseStrategy<AstExpressionMatcher> EXPRESSION_MATCHER = new ScriptParseStrategy<AstExpressionMatcher>(){

        @Override
        public AstExpressionMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstExpressionMatcher)new AstExpressionMatcherVisitor(factory, environment).visit((ParseTree)parser.expressionMatcher());
        }
    };
    public static final ScriptParseStrategy<AstFixedLengthBytesMatcher> FIXED_LENGTH_BYTES_MATCHER = new ScriptParseStrategy<AstFixedLengthBytesMatcher>(){

        @Override
        public AstFixedLengthBytesMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstFixedLengthBytesMatcher)new AstFixedLengthBytesMatcherVisitor(factory, environment).visit((ParseTree)parser.fixedLengthBytesMatcher());
        }
    };
    public static final ScriptParseStrategy<AstVariableLengthBytesMatcher> VARIABLE_LENGTH_BYTES_MATCHER = new ScriptParseStrategy<AstVariableLengthBytesMatcher>(){

        @Override
        public AstVariableLengthBytesMatcher parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstVariableLengthBytesMatcher)new AstVariableLengthBytesMatcherVisitor(factory, environment).visit((ParseTree)parser.variableLengthBytesMatcher());
        }
    };
    public static final ScriptParseStrategy<AstLiteralTextValue> LITERAL_TEXT_VALUE = new ScriptParseStrategy<AstLiteralTextValue>(){

        @Override
        public AstLiteralTextValue parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstLiteralTextValue)new AstLiteralTextValueVisitor(factory, environment).visit((ParseTree)parser.literalText());
        }
    };
    public static final ScriptParseStrategy<AstLiteralBytesValue> LITERAL_BYTES_VALUE = new ScriptParseStrategy<AstLiteralBytesValue>(){

        @Override
        public AstLiteralBytesValue parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstLiteralBytesValue)new AstLiteralBytesValueVisitor(factory, environment).visit((ParseTree)parser.literalBytes());
        }
    };
    public static final ScriptParseStrategy<AstReadOptionNode> READ_OPTION = new ScriptParseStrategy<AstReadOptionNode>(){

        @Override
        public AstReadOptionNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadOptionNode)new AstReadOptionNodeVisitor(factory, environment).visit((ParseTree)parser.readOptionNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteOptionNode> WRITE_OPTION = new ScriptParseStrategy<AstWriteOptionNode>(){

        @Override
        public AstWriteOptionNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteOptionNode)new AstWriteOptionNodeVisitor(factory, environment).visit((ParseTree)parser.writeOptionNode());
        }
    };
    public static final ScriptParseStrategy<AstReadConfigNode> READ_CONFIG = new ScriptParseStrategy<AstReadConfigNode>(){

        @Override
        public AstReadConfigNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstReadConfigNode)new AstReadConfigNodeVisitor(factory, environment).visit((ParseTree)parser.readConfigNode());
        }
    };
    public static final ScriptParseStrategy<AstWriteConfigNode> WRITE_CONFIG = new ScriptParseStrategy<AstWriteConfigNode>(){

        @Override
        public AstWriteConfigNode parse(RobotParser parser, ExpressionFactory factory, ExpressionContext environment) throws RecognitionException {
            return (AstWriteConfigNode)new AstWriteConfigNodeVisitor(factory, environment).visit((ParseTree)parser.writeConfigNode());
        }
    };
    private static final TypeSystem TYPE_SYSTEM = TypeSystem.newInstance();

    public abstract T parse(RobotParser var1, ExpressionFactory var2, ExpressionContext var3) throws RecognitionException;

    private static String escapeString(String toEscape) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toEscape.length(); ++i) {
            char current = toEscape.charAt(i);
            if (current == '\\') {
                char next = toEscape.charAt(i + 1);
                switch (next) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                ++i;
                continue;
            }
            sb.append(current);
        }
        return sb.toString();
    }

    private static RegionInfo asSequentialRegion(List<RegionInfo> childInfos, ParserRuleContext ctx) {
        if (childInfos.isEmpty()) {
            return RegionInfo.newSequential(ScriptParseStrategy.startIndex(ctx.start), ScriptParseStrategy.stopIndex(ctx.stop) + 1);
        }
        return RegionInfo.newSequential(childInfos, ScriptParseStrategy.startIndex(ctx.start), ScriptParseStrategy.stopIndex(ctx.stop) + 1);
    }

    private static RegionInfo asParallelRegion(List<RegionInfo> childInfos, ParserRuleContext ctx) {
        if (childInfos.isEmpty()) {
            return RegionInfo.newParallel(ScriptParseStrategy.startIndex(ctx.start), ScriptParseStrategy.stopIndex(ctx.stop) + 1);
        }
        return RegionInfo.newParallel(childInfos, ScriptParseStrategy.startIndex(ctx.start), ScriptParseStrategy.stopIndex(ctx.stop) + 1);
    }

    private static int startIndex(Token token) {
        return token != null && token.getType() != -1 ? token.getStartIndex() : 0;
    }

    private static int stopIndex(Token token) {
        return token != null ? token.getStopIndex() : 0;
    }

    private static class AstWriteCloseNodeVisitor
    extends AstNodeVisitor<AstWriteCloseNode> {
        public AstWriteCloseNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteCloseNode visitWriteCloseNode(RobotParser.WriteCloseNodeContext ctx) {
            this.node = new AstWriteCloseNode();
            ((AstWriteCloseNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstWriteCloseNode)this.node;
        }
    }

    private static class AstReadClosedNodeVisitor
    extends AstNodeVisitor<AstReadClosedNode> {
        public AstReadClosedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadClosedNode visitReadClosedNode(RobotParser.ReadClosedNodeContext ctx) {
            this.node = new AstReadClosedNode();
            ((AstReadClosedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstReadClosedNode)this.node;
        }
    }

    private static class AstWriteFlushNodeVisitor
    extends AstNodeVisitor<AstWriteFlushNode> {
        public AstWriteFlushNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteFlushNode visitWriteFlushNode(RobotParser.WriteFlushNodeContext ctx) {
            this.node = new AstWriteFlushNode();
            ((AstWriteFlushNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstWriteFlushNode)this.node;
        }
    }

    private static class AstWriteConfigNodeVisitor
    extends AstNodeVisitor<AstWriteConfigNode> {
        private Iterator<TypeInfo<?>> namedFields;
        private int anonymousFields;

        public AstWriteConfigNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteConfigNode visitWriteConfigNode(RobotParser.WriteConfigNodeContext ctx) {
            String configQName = ctx.QualifiedName().getText();
            this.node = new AstWriteConfigNode();
            StructuredTypeInfo configType = TYPE_SYSTEM.writeConfig(configQName);
            this.namedFields = configType.getNamedFields().iterator();
            this.anonymousFields = configType.getAnonymousFields();
            ((AstWriteConfigNode)this.node).setType(configType);
            super.visitWriteConfigNode(ctx);
            ((AstWriteConfigNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstWriteConfigNode)this.node;
        }

        @Override
        public AstWriteConfigNode visitWriteValue(RobotParser.WriteValueContext ctx) {
            AstValueVisitor<Object> visitor = new AstValueVisitor<Object>(this.factory, this.environment, Object.class);
            AstValue value = (AstValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                if (this.namedFields.hasNext()) {
                    TypeInfo<?> field = this.namedFields.next();
                    ((AstWriteConfigNode)this.node).setValue(field.getName(), value);
                } else if (this.anonymousFields > 0) {
                    --this.anonymousFields;
                    ((AstWriteConfigNode)this.node).addValue(value);
                } else {
                    throw new IllegalStateException(String.format("Unexpected %s syntax", ((AstWriteConfigNode)this.node).getType()));
                }
                this.childInfos().add(value.getRegionInfo());
            }
            return (AstWriteConfigNode)this.node;
        }
    }

    private static class AstReadConfigNodeVisitor
    extends AstNodeVisitor<AstReadConfigNode> {
        private Iterator<TypeInfo<?>> namedFields;
        private int anonymousFields;

        public AstReadConfigNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadConfigNode visitReadConfigNode(RobotParser.ReadConfigNodeContext ctx) {
            String configQName = ctx.QualifiedName().getText();
            boolean missing = ctx.MissingKeyword() != null;
            this.node = new AstReadConfigNode();
            ((AstReadConfigNode)this.node).setMissing(missing);
            StructuredTypeInfo configType = TYPE_SYSTEM.readConfig(configQName);
            this.namedFields = configType.getNamedFields().iterator();
            this.anonymousFields = configType.getAnonymousFields();
            ((AstReadConfigNode)this.node).setType(configType);
            super.visitReadConfigNode(ctx);
            ((AstReadConfigNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstReadConfigNode)this.node;
        }

        @Override
        public AstReadConfigNode visitMatcher(RobotParser.MatcherContext ctx) {
            AstValueMatcherVisitor visitor = new AstValueMatcherVisitor(this.factory, this.environment);
            AstValueMatcher matcher = (AstValueMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                if (this.namedFields.hasNext()) {
                    TypeInfo<?> field = this.namedFields.next();
                    ((AstReadConfigNode)this.node).setMatcher(field.getName(), matcher);
                } else if (this.anonymousFields > 0) {
                    --this.anonymousFields;
                    ((AstReadConfigNode)this.node).addMatcher(matcher);
                } else {
                    throw new IllegalStateException(String.format("Unexpected %s syntax", ((AstReadConfigNode)this.node).getType()));
                }
                this.childInfos().add(matcher.getRegionInfo());
            }
            return (AstReadConfigNode)this.node;
        }
    }

    private static class AstExpressionValueVisitor<T>
    extends AstVisitor<AstExpressionValue<T>> {
        private final Class<T> expectedType;

        public AstExpressionValueVisitor(ExpressionFactory factory, ExpressionContext environment, Class<T> expectedType) {
            super(factory, environment);
            this.expectedType = expectedType;
        }

        @Override
        public AstExpressionValue<T> visitExpressionValue(RobotParser.ExpressionValueContext ctx) {
            ValueExpression expression = this.factory.createValueExpression((ELContext)this.environment, ctx.expression.getText(), this.expectedType);
            AstExpressionValue value = new AstExpressionValue(expression, this.environment);
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstLiteralLongValueVisitor
    extends AstVisitor<AstLiteralLongValue> {
        public AstLiteralLongValueVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstLiteralLongValue visitLiteralLong(RobotParser.LiteralLongContext ctx) {
            String literal = ctx.literal.getText().replaceAll("_", "");
            AstLiteralLongValue value = new AstLiteralLongValue(Long.decode(literal));
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstLiteralIntegerValueVisitor
    extends AstVisitor<AstLiteralIntegerValue> {
        public AstLiteralIntegerValueVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstLiteralIntegerValue visitLiteralInteger(RobotParser.LiteralIntegerContext ctx) {
            String literal = ctx.literal.getText().replaceAll("_", "");
            AstLiteralIntegerValue value = new AstLiteralIntegerValue(Integer.decode(literal));
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstLiteralShortValueVisitor
    extends AstVisitor<AstLiteralShortValue> {
        public AstLiteralShortValueVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstLiteralShortValue visitLiteralShort(RobotParser.LiteralShortContext ctx) {
            String literal = ctx.literal.getText().replaceAll("_", "");
            AstLiteralShortValue value = new AstLiteralShortValue(Short.decode(literal));
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstLiteralByteValueVisitor
    extends AstVisitor<AstLiteralByteValue> {
        public AstLiteralByteValueVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstLiteralByteValue visitLiteralByte(RobotParser.LiteralByteContext ctx) {
            String literal = ctx.literal.getText().replaceAll("_", "");
            AstLiteralByteValue value = new AstLiteralByteValue(Byte.decode(literal));
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstLiteralBytesValueVisitor
    extends AstVisitor<AstLiteralBytesValue> {
        public AstLiteralBytesValueVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstLiteralBytesValue visitLiteralBytes(RobotParser.LiteralBytesContext ctx) {
            String literal = ctx.literal.getText();
            AstLiteralBytesValue value = new AstLiteralBytesValue(ParserHelper.parseHexBytes(literal));
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstLiteralURIValueVisitor
    extends AstVisitor<AstLiteralURIValue> {
        public AstLiteralURIValueVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstLiteralURIValue visitLiteralText(RobotParser.LiteralTextContext ctx) {
            String literal = ctx.literal.getText();
            String textWithoutQuotes = literal.substring(1, literal.length() - 1);
            String escapedText = ScriptParseStrategy.escapeString(textWithoutQuotes);
            AstLiteralURIValue value = new AstLiteralURIValue(URI.create(escapedText));
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstLiteralTextValueVisitor
    extends AstVisitor<AstLiteralTextValue> {
        public AstLiteralTextValueVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstLiteralTextValue visitLiteralText(RobotParser.LiteralTextContext ctx) {
            String text = ctx.literal.getText();
            String textWithoutQuotes = text.substring(1, text.length() - 1);
            String escapedText = ScriptParseStrategy.escapeString(textWithoutQuotes);
            AstLiteralTextValue value = new AstLiteralTextValue(escapedText);
            value.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return value;
        }
    }

    private static class AstValueVisitor<T>
    extends AstVisitor<AstValue<T>> {
        private final Class<T> expectedType;

        public AstValueVisitor(ExpressionFactory factory, ExpressionContext environment, Class<T> expectedType) {
            super(factory, environment);
            this.expectedType = expectedType;
        }

        @Override
        public AstValue<T> visitLiteralBytes(RobotParser.LiteralBytesContext ctx) {
            AstLiteralBytesValueVisitor visitor = new AstLiteralBytesValueVisitor(this.factory, this.environment);
            AstLiteralBytesValue value = (AstLiteralBytesValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }

        @Override
        public AstValue<T> visitLiteralByte(RobotParser.LiteralByteContext ctx) {
            AstLiteralByteValueVisitor visitor = new AstLiteralByteValueVisitor(this.factory, this.environment);
            AstLiteralByteValue value = (AstLiteralByteValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }

        @Override
        public AstValue<T> visitLiteralShort(RobotParser.LiteralShortContext ctx) {
            AstLiteralShortValueVisitor visitor = new AstLiteralShortValueVisitor(this.factory, this.environment);
            AstLiteralShortValue value = (AstLiteralShortValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }

        @Override
        public AstValue<T> visitLiteralInteger(RobotParser.LiteralIntegerContext ctx) {
            AstLiteralIntegerValueVisitor visitor = new AstLiteralIntegerValueVisitor(this.factory, this.environment);
            AstLiteralIntegerValue literal = (AstLiteralIntegerValue)visitor.visit((ParseTree)ctx);
            AstValue value = literal;
            if (this.expectedType == Long.TYPE || this.expectedType == Long.class) {
                value = new AstLiteralLongValue(literal.getValue().longValue());
            }
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }

        @Override
        public AstValue<T> visitLiteralLong(RobotParser.LiteralLongContext ctx) {
            AstLiteralLongValueVisitor visitor = new AstLiteralLongValueVisitor(this.factory, this.environment);
            AstLiteralLongValue value = (AstLiteralLongValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }

        @Override
        public AstValue<T> visitLiteralText(RobotParser.LiteralTextContext ctx) {
            if (this.expectedType == URI.class) {
                AstLiteralURIValueVisitor visitor = new AstLiteralURIValueVisitor(this.factory, this.environment);
                AstLiteralURIValue value = (AstLiteralURIValue)visitor.visit((ParseTree)ctx);
                if (value != null) {
                    this.childInfos().add(value.getRegionInfo());
                }
                return value;
            }
            AstLiteralTextValueVisitor visitor = new AstLiteralTextValueVisitor(this.factory, this.environment);
            AstLiteralTextValue value = (AstLiteralTextValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }

        @Override
        public AstValue<T> visitExpressionValue(RobotParser.ExpressionValueContext ctx) {
            AstExpressionValueVisitor<T> visitor = new AstExpressionValueVisitor<T>(this.factory, this.environment, this.expectedType);
            AstExpressionValue value = (AstExpressionValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }
    }

    private static class AstLocationVisitor
    extends AstVisitor<AstValue<URI>> {
        protected AstLocationVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstValue<URI> visitLiteralText(RobotParser.LiteralTextContext ctx) {
            AstLiteralURIValueVisitor visitor = new AstLiteralURIValueVisitor(this.factory, this.environment);
            AstLiteralURIValue value = (AstLiteralURIValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }

        @Override
        public AstValue<URI> visitExpressionValue(RobotParser.ExpressionValueContext ctx) {
            AstExpressionValueVisitor<URI> visitor = new AstExpressionValueVisitor<URI>(this.factory, this.environment, URI.class);
            AstExpressionValue value = (AstExpressionValue)visitor.visit((ParseTree)ctx);
            if (value != null) {
                this.childInfos().add(value.getRegionInfo());
            }
            return value;
        }
    }

    private static class AstVariableLengthBytesMatcherVisitor
    extends AstVisitor<AstVariableLengthBytesMatcher> {
        public AstVariableLengthBytesMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstVariableLengthBytesMatcher visitVariableLengthBytesMatcher(RobotParser.VariableLengthBytesMatcherContext ctx) {
            ValueExpression length = this.factory.createValueExpression((ELContext)this.environment, ctx.length.getText(), Integer.class);
            if (ctx.capture != null) {
                String capture = ctx.capture.getText();
                String captureName = capture.substring(1);
                AstVariableLengthBytesMatcher matcher = new AstVariableLengthBytesMatcher(length, captureName, this.environment);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            AstVariableLengthBytesMatcher matcher = new AstVariableLengthBytesMatcher(length, this.environment);
            matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return matcher;
        }
    }

    private static class AstFixedLengthBytesMatcherVisitor
    extends AstVisitor<AstFixedLengthBytesMatcher> {
        public AstFixedLengthBytesMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstFixedLengthBytesMatcher visitFixedLengthBytesMatcher(RobotParser.FixedLengthBytesMatcherContext ctx) {
            if (ctx.lastIndex != null) {
                String lastIndex = ctx.lastIndex.getText();
                if (ctx.capture != null) {
                    String capture = ctx.capture.getText();
                    String captureName = capture.substring(1, capture.length());
                    AstFixedLengthBytesMatcher matcher = new AstFixedLengthBytesMatcher(Integer.parseInt(lastIndex), captureName, this.environment);
                    matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                    return matcher;
                }
                AstFixedLengthBytesMatcher matcher = new AstFixedLengthBytesMatcher(Integer.parseInt(lastIndex));
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            if (ctx.byteCapture != null) {
                String byteCapture = ctx.byteCapture.getText();
                AstByteLengthBytesMatcher matcher = new AstByteLengthBytesMatcher(byteCapture.substring(1), this.environment);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            if (ctx.shortCapture != null) {
                String shortCapture = ctx.shortCapture.getText();
                AstShortLengthBytesMatcher matcher = new AstShortLengthBytesMatcher(shortCapture.substring(1), this.environment);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            if (ctx.intCapture != null) {
                String intCapture = ctx.intCapture.getText();
                AstIntLengthBytesMatcher matcher = new AstIntLengthBytesMatcher(intCapture.substring(1), this.environment);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            if (ctx.longCapture != null) {
                String longCapture = ctx.longCapture.getText();
                AstLongLengthBytesMatcher matcher = new AstLongLengthBytesMatcher(longCapture.substring(1), this.environment);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            return null;
        }
    }

    private static class AstExpressionMatcherVisitor
    extends AstVisitor<AstExpressionMatcher> {
        public AstExpressionMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstExpressionMatcher visitExpressionMatcher(RobotParser.ExpressionMatcherContext ctx) {
            ValueExpression expression = this.factory.createValueExpression((ELContext)this.environment, ctx.expression.getText(), Object.class);
            AstExpressionMatcher matcher = new AstExpressionMatcher(expression, this.environment);
            matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return matcher;
        }
    }

    private static class AstRegexMatcherVisitor
    extends AstVisitor<AstRegexMatcher> {
        public AstRegexMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstRegexMatcher visitRegexMatcher(RobotParser.RegexMatcherContext ctx) {
            String regex = ctx.regex.getText();
            String pattern = regex.substring(1, regex.length() - 1);
            AstRegexMatcher matcher = new AstRegexMatcher(NamedGroupPattern.compile(pattern), this.environment);
            matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return matcher;
        }
    }

    private static class AstNumberMatcherVisitor
    extends AstVisitor<AstNumberMatcher> {
        public AstNumberMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstNumberMatcher visitNumberMatcher(RobotParser.NumberMatcherContext ctx) {
            if (ctx.longLiteral != null) {
                Long literal = Long.decode(ctx.longLiteral.getText().replaceAll("\\_", ""));
                AstNumberMatcher matcher = new AstNumberMatcher(literal);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            if (ctx.intLiteral != null) {
                Integer literal = Integer.decode(ctx.intLiteral.getText().replaceAll("\\_", ""));
                AstNumberMatcher matcher = new AstNumberMatcher(literal);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            if (ctx.shortLiteral != null) {
                Short literal = Short.decode(ctx.shortLiteral.getText().replaceAll("\\_", ""));
                AstNumberMatcher matcher = new AstNumberMatcher(literal);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            if (ctx.byteLiteral != null) {
                Byte literal = Byte.decode(ctx.byteLiteral.getText().replaceAll("\\_", ""));
                AstNumberMatcher matcher = new AstNumberMatcher(literal);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            return null;
        }
    }

    private static class AstExactBytesMatcherVisitor
    extends AstVisitor<AstExactBytesMatcher> {
        public AstExactBytesMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstExactBytesMatcher visitExactBytesMatcher(RobotParser.ExactBytesMatcherContext ctx) {
            if (ctx.bytes != null) {
                byte[] array = ParserHelper.parseHexBytes(ctx.bytes.getText());
                AstExactBytesMatcher matcher = new AstExactBytesMatcher(array);
                matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
                return matcher;
            }
            return null;
        }
    }

    private static class AstExactTextMatcherVisitor
    extends AstVisitor<AstExactTextMatcher> {
        public AstExactTextMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstExactTextMatcher visitExactTextMatcher(RobotParser.ExactTextMatcherContext ctx) {
            String text = ctx.text.getText();
            String textWithoutQuote = text.substring(1, text.length() - 1);
            String escapedText = ScriptParseStrategy.escapeString(textWithoutQuote);
            AstExactTextMatcher matcher = new AstExactTextMatcher(escapedText);
            matcher.setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return matcher;
        }
    }

    private static class AstValueMatcherVisitor
    extends AstVisitor<AstValueMatcher> {
        public AstValueMatcherVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstValueMatcher visitExactTextMatcher(RobotParser.ExactTextMatcherContext ctx) {
            AstExactTextMatcherVisitor visitor = new AstExactTextMatcherVisitor(this.factory, this.environment);
            AstExactTextMatcher matcher = (AstExactTextMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                this.childInfos().add(matcher.getRegionInfo());
            }
            return matcher;
        }

        @Override
        public AstExactBytesMatcher visitExactBytesMatcher(RobotParser.ExactBytesMatcherContext ctx) {
            AstExactBytesMatcherVisitor visitor = new AstExactBytesMatcherVisitor(this.factory, this.environment);
            AstExactBytesMatcher matcher = (AstExactBytesMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                this.childInfos().add(matcher.getRegionInfo());
            }
            return matcher;
        }

        @Override
        public AstValueMatcher visitNumberMatcher(RobotParser.NumberMatcherContext ctx) {
            AstNumberMatcherVisitor visitor = new AstNumberMatcherVisitor(this.factory, this.environment);
            AstNumberMatcher matcher = (AstNumberMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                this.childInfos().add(matcher.getRegionInfo());
            }
            return matcher;
        }

        @Override
        public AstRegexMatcher visitRegexMatcher(RobotParser.RegexMatcherContext ctx) {
            AstRegexMatcherVisitor visitor = new AstRegexMatcherVisitor(this.factory, this.environment);
            AstRegexMatcher matcher = (AstRegexMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                this.childInfos().add(matcher.getRegionInfo());
            }
            return matcher;
        }

        @Override
        public AstExpressionMatcher visitExpressionMatcher(RobotParser.ExpressionMatcherContext ctx) {
            AstExpressionMatcherVisitor visitor = new AstExpressionMatcherVisitor(this.factory, this.environment);
            AstExpressionMatcher matcher = (AstExpressionMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                this.childInfos().add(matcher.getRegionInfo());
            }
            return matcher;
        }

        @Override
        public AstFixedLengthBytesMatcher visitFixedLengthBytesMatcher(RobotParser.FixedLengthBytesMatcherContext ctx) {
            AstFixedLengthBytesMatcherVisitor visitor = new AstFixedLengthBytesMatcherVisitor(this.factory, this.environment);
            AstFixedLengthBytesMatcher matcher = (AstFixedLengthBytesMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                this.childInfos().add(matcher.getRegionInfo());
            }
            return matcher;
        }

        @Override
        public AstVariableLengthBytesMatcher visitVariableLengthBytesMatcher(RobotParser.VariableLengthBytesMatcherContext ctx) {
            AstVariableLengthBytesMatcherVisitor visitor = new AstVariableLengthBytesMatcherVisitor(this.factory, this.environment);
            AstVariableLengthBytesMatcher matcher = (AstVariableLengthBytesMatcher)visitor.visit((ParseTree)ctx);
            if (matcher != null) {
                this.childInfos().add(matcher.getRegionInfo());
            }
            return matcher;
        }
    }

    private static class AstWriteNotifyNodeVisitor
    extends AstNodeVisitor<AstWriteNotifyNode> {
        public AstWriteNotifyNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteNotifyNode visitWriteNotifyNode(RobotParser.WriteNotifyNodeContext ctx) {
            this.node = new AstWriteNotifyNode();
            ((AstWriteNotifyNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            ((AstWriteNotifyNode)this.node).setBarrierName(ctx.Name().getText());
            return (AstWriteNotifyNode)this.node;
        }
    }

    private static class AstWriteAwaitNodeVisitor
    extends AstNodeVisitor<AstWriteAwaitNode> {
        public AstWriteAwaitNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteAwaitNode visitWriteAwaitNode(RobotParser.WriteAwaitNodeContext ctx) {
            this.node = new AstWriteAwaitNode();
            ((AstWriteAwaitNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            ((AstWriteAwaitNode)this.node).setBarrierName(ctx.Name().getText());
            return (AstWriteAwaitNode)this.node;
        }
    }

    private static class AstReadNotifyNodeVisitor
    extends AstNodeVisitor<AstReadNotifyNode> {
        public AstReadNotifyNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadNotifyNode visitReadNotifyNode(RobotParser.ReadNotifyNodeContext ctx) {
            this.node = new AstReadNotifyNode();
            ((AstReadNotifyNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            ((AstReadNotifyNode)this.node).setBarrierName(ctx.Name().getText());
            return (AstReadNotifyNode)this.node;
        }
    }

    private static class AstReadAwaitNodeVisitor
    extends AstNodeVisitor<AstReadAwaitNode> {
        public AstReadAwaitNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadAwaitNode visitReadAwaitNode(RobotParser.ReadAwaitNodeContext ctx) {
            this.node = new AstReadAwaitNode();
            ((AstReadAwaitNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            ((AstReadAwaitNode)this.node).setBarrierName(ctx.Name().getText());
            return (AstReadAwaitNode)this.node;
        }
    }

    private static class AstUnboundNodeVisitor
    extends AstNodeVisitor<AstUnboundNode> {
        public AstUnboundNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstUnboundNode visitUnboundNode(RobotParser.UnboundNodeContext ctx) {
            this.node = new AstUnboundNode();
            ((AstUnboundNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstUnboundNode)this.node;
        }
    }

    private static class AstReadValueNodeVisitor
    extends AstNodeVisitor<AstReadValueNode> {
        public AstReadValueNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadValueNode visitReadNode(RobotParser.ReadNodeContext ctx) {
            this.node = new AstReadValueNode();
            super.visitReadNode(ctx);
            ((AstReadValueNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstReadValueNode)this.node;
        }

        @Override
        public AstReadValueNode visitMatcher(RobotParser.MatcherContext ctx) {
            AstValueMatcherVisitor visitor = new AstValueMatcherVisitor(this.factory, this.environment);
            AstValueMatcher matcher = (AstValueMatcher)visitor.visit((ParseTree)ctx);
            ((AstReadValueNode)this.node).addMatcher(matcher);
            this.childInfos().add(matcher.getRegionInfo());
            return (AstReadValueNode)this.node;
        }
    }

    private static class AstOpenedNodeVisitor
    extends AstNodeVisitor<AstOpenedNode> {
        public AstOpenedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstOpenedNode visitOpenedNode(RobotParser.OpenedNodeContext ctx) {
            this.node = new AstOpenedNode();
            ((AstOpenedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstOpenedNode)this.node;
        }
    }

    private static class AstDisconnectedNodeVisitor
    extends AstNodeVisitor<AstDisconnectedNode> {
        public AstDisconnectedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstDisconnectedNode visitDisconnectedNode(RobotParser.DisconnectedNodeContext ctx) {
            this.node = new AstDisconnectedNode();
            ((AstDisconnectedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstDisconnectedNode)this.node;
        }
    }

    private static class AstConnectedNodeVisitor
    extends AstNodeVisitor<AstConnectedNode> {
        public AstConnectedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstConnectedNode visitConnectedNode(RobotParser.ConnectedNodeContext ctx) {
            this.node = new AstConnectedNode();
            ((AstConnectedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstConnectedNode)this.node;
        }
    }

    private static class AstWriteAbortedNodeVisitor
    extends AstNodeVisitor<AstWriteAbortedNode> {
        public AstWriteAbortedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteAbortedNode visitWriteAbortedNode(RobotParser.WriteAbortedNodeContext ctx) {
            this.node = new AstWriteAbortedNode();
            ((AstWriteAbortedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstWriteAbortedNode)this.node;
        }
    }

    private static class AstReadAbortedNodeVisitor
    extends AstNodeVisitor<AstReadAbortedNode> {
        public AstReadAbortedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadAbortedNode visitReadAbortedNode(RobotParser.ReadAbortedNodeContext ctx) {
            this.node = new AstReadAbortedNode();
            ((AstReadAbortedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstReadAbortedNode)this.node;
        }
    }

    private static class AstClosedNodeVisitor
    extends AstNodeVisitor<AstClosedNode> {
        public AstClosedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstClosedNode visitClosedNode(RobotParser.ClosedNodeContext ctx) {
            this.node = new AstClosedNode();
            ((AstClosedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstClosedNode)this.node;
        }
    }

    private static class AstBoundNodeVisitor
    extends AstNodeVisitor<AstBoundNode> {
        public AstBoundNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstBoundNode visitBoundNode(RobotParser.BoundNodeContext ctx) {
            this.node = new AstBoundNode();
            ((AstBoundNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstBoundNode)this.node;
        }
    }

    private static class AstChildClosedNodeVisitor
    extends AstNodeVisitor<AstChildClosedNode> {
        public AstChildClosedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstChildClosedNode visitChildClosedNode(RobotParser.ChildClosedNodeContext ctx) {
            this.node = new AstChildClosedNode();
            ((AstChildClosedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstChildClosedNode)this.node;
        }
    }

    private static class AstChildOpenedNodeVisitor
    extends AstNodeVisitor<AstChildOpenedNode> {
        public AstChildOpenedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstChildOpenedNode visitChildOpenedNode(RobotParser.ChildOpenedNodeContext ctx) {
            this.node = new AstChildOpenedNode();
            ((AstChildOpenedNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstChildOpenedNode)this.node;
        }
    }

    private static class AstWriteValueNodeVisitor
    extends AstNodeVisitor<AstWriteValueNode> {
        public AstWriteValueNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteValueNode visitWriteNode(RobotParser.WriteNodeContext ctx) {
            this.node = new AstWriteValueNode();
            super.visitWriteNode(ctx);
            ((AstWriteValueNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstWriteValueNode)this.node;
        }

        @Override
        public AstWriteValueNode visitWriteValue(RobotParser.WriteValueContext ctx) {
            AstValueVisitor<Object> visitor = new AstValueVisitor<Object>(this.factory, this.environment, Object.class);
            AstValue value = (AstValue)visitor.visit((ParseTree)ctx);
            ((AstWriteValueNode)this.node).addValue(value);
            this.childInfos().add(value.getRegionInfo());
            return (AstWriteValueNode)this.node;
        }
    }

    private static class AstUnbindNodeVisitor
    extends AstNodeVisitor<AstUnbindNode> {
        public AstUnbindNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstUnbindNode visitUnbindNode(RobotParser.UnbindNodeContext ctx) {
            this.node = new AstUnbindNode();
            ((AstUnbindNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstUnbindNode)this.node;
        }
    }

    private static class AstDisconnectNodeVisitor
    extends AstNodeVisitor<AstDisconnectNode> {
        public AstDisconnectNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstDisconnectNode visitDisconnectNode(RobotParser.DisconnectNodeContext ctx) {
            this.node = new AstDisconnectNode();
            ((AstDisconnectNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstDisconnectNode)this.node;
        }
    }

    private static class AstReadAbortNodeVisitor
    extends AstNodeVisitor<AstReadAbortNode> {
        public AstReadAbortNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadAbortNode visitReadAbortNode(RobotParser.ReadAbortNodeContext ctx) {
            this.node = new AstReadAbortNode();
            ((AstReadAbortNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstReadAbortNode)this.node;
        }
    }

    private static class AstWriteAbortNodeVisitor
    extends AstNodeVisitor<AstWriteAbortNode> {
        public AstWriteAbortNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteAbortNode visitWriteAbortNode(RobotParser.WriteAbortNodeContext ctx) {
            this.node = new AstWriteAbortNode();
            ((AstWriteAbortNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstWriteAbortNode)this.node;
        }
    }

    private static class AstCloseNodeVisitor
    extends AstNodeVisitor<AstCloseNode> {
        public AstCloseNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstCloseNode visitCloseNode(RobotParser.CloseNodeContext ctx) {
            this.node = new AstCloseNode();
            ((AstCloseNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstCloseNode)this.node;
        }
    }

    private static class AstCommandNodeVisitor
    extends AstNodeVisitor<AstCommandNode> {
        public AstCommandNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstConnectAbortNode visitConnectAbortNode(RobotParser.ConnectAbortNodeContext ctx) {
            AstConnectAbortNodeVisitor visitor = new AstConnectAbortNodeVisitor(this.factory, this.environment);
            AstConnectAbortNode connectAbortNode = visitor.visitConnectAbortNode(ctx);
            if (connectAbortNode != null) {
                this.childInfos().add(connectAbortNode.getRegionInfo());
            }
            return connectAbortNode;
        }

        @Override
        public AstUnbindNode visitUnbindNode(RobotParser.UnbindNodeContext ctx) {
            AstUnbindNodeVisitor visitor = new AstUnbindNodeVisitor(this.factory, this.environment);
            AstUnbindNode unbindNode = visitor.visitUnbindNode(ctx);
            if (unbindNode != null) {
                this.childInfos().add(unbindNode.getRegionInfo());
            }
            return unbindNode;
        }

        @Override
        public AstWriteConfigNode visitWriteConfigNode(RobotParser.WriteConfigNodeContext ctx) {
            AstWriteConfigNodeVisitor visitor = new AstWriteConfigNodeVisitor(this.factory, this.environment);
            AstWriteConfigNode writeConfigNode = visitor.visitWriteConfigNode(ctx);
            if (writeConfigNode != null) {
                this.childInfos().add(writeConfigNode.getRegionInfo());
            }
            return writeConfigNode;
        }

        @Override
        public AstWriteValueNode visitWriteNode(RobotParser.WriteNodeContext ctx) {
            AstWriteValueNodeVisitor visitor = new AstWriteValueNodeVisitor(this.factory, this.environment);
            AstWriteValueNode writeNode = visitor.visitWriteNode(ctx);
            if (writeNode != null) {
                this.childInfos().add(writeNode.getRegionInfo());
            }
            return writeNode;
        }

        @Override
        public AstWriteFlushNode visitWriteFlushNode(RobotParser.WriteFlushNodeContext ctx) {
            AstWriteFlushNodeVisitor visitor = new AstWriteFlushNodeVisitor(this.factory, this.environment);
            AstWriteFlushNode writeFlushNode = visitor.visitWriteFlushNode(ctx);
            if (writeFlushNode != null) {
                this.childInfos().add(writeFlushNode.getRegionInfo());
            }
            return writeFlushNode;
        }

        @Override
        public AstWriteCloseNode visitWriteCloseNode(RobotParser.WriteCloseNodeContext ctx) {
            AstWriteCloseNodeVisitor visitor = new AstWriteCloseNodeVisitor(this.factory, this.environment);
            AstWriteCloseNode writeCloseNode = visitor.visitWriteCloseNode(ctx);
            if (writeCloseNode != null) {
                this.childInfos().add(writeCloseNode.getRegionInfo());
            }
            return writeCloseNode;
        }

        @Override
        public AstCloseNode visitCloseNode(RobotParser.CloseNodeContext ctx) {
            AstCloseNodeVisitor visitor = new AstCloseNodeVisitor(this.factory, this.environment);
            AstCloseNode closeNode = visitor.visitCloseNode(ctx);
            if (closeNode != null) {
                this.childInfos().add(closeNode.getRegionInfo());
            }
            return closeNode;
        }

        @Override
        public AstWriteAbortNode visitWriteAbortNode(RobotParser.WriteAbortNodeContext ctx) {
            AstWriteAbortNodeVisitor visitor = new AstWriteAbortNodeVisitor(this.factory, this.environment);
            AstWriteAbortNode abortNode = visitor.visitWriteAbortNode(ctx);
            if (abortNode != null) {
                this.childInfos().add(abortNode.getRegionInfo());
            }
            return abortNode;
        }

        @Override
        public AstReadAbortNode visitReadAbortNode(RobotParser.ReadAbortNodeContext ctx) {
            AstReadAbortNodeVisitor visitor = new AstReadAbortNodeVisitor(this.factory, this.environment);
            AstReadAbortNode abortNode = visitor.visitReadAbortNode(ctx);
            if (abortNode != null) {
                this.childInfos().add(abortNode.getRegionInfo());
            }
            return abortNode;
        }
    }

    private static class AstEventNodeVisitor
    extends AstNodeVisitor<AstEventNode> {
        public AstEventNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstBoundNode visitBoundNode(RobotParser.BoundNodeContext ctx) {
            AstBoundNodeVisitor visitor = new AstBoundNodeVisitor(this.factory, this.environment);
            AstBoundNode boundNode = visitor.visitBoundNode(ctx);
            if (boundNode != null) {
                this.childInfos().add(boundNode.getRegionInfo());
            }
            return boundNode;
        }

        @Override
        public AstClosedNode visitClosedNode(RobotParser.ClosedNodeContext ctx) {
            AstClosedNodeVisitor visitor = new AstClosedNodeVisitor(this.factory, this.environment);
            AstClosedNode closedNode = visitor.visitClosedNode(ctx);
            if (closedNode != null) {
                this.childInfos().add(closedNode.getRegionInfo());
            }
            return closedNode;
        }

        @Override
        public AstConnectAbortedNode visitConnectAbortedNode(RobotParser.ConnectAbortedNodeContext ctx) {
            AstConnectAbortedNodeVisitor visitor = new AstConnectAbortedNodeVisitor(this.factory, this.environment);
            AstConnectAbortedNode connectAbortedNode = visitor.visitConnectAbortedNode(ctx);
            if (connectAbortedNode != null) {
                this.childInfos().add(connectAbortedNode.getRegionInfo());
            }
            return connectAbortedNode;
        }

        @Override
        public AstConnectedNode visitConnectedNode(RobotParser.ConnectedNodeContext ctx) {
            AstConnectedNodeVisitor visitor = new AstConnectedNodeVisitor(this.factory, this.environment);
            AstConnectedNode connectedNode = visitor.visitConnectedNode(ctx);
            if (connectedNode != null) {
                this.childInfos().add(connectedNode.getRegionInfo());
            }
            return connectedNode;
        }

        @Override
        public AstDisconnectedNode visitDisconnectedNode(RobotParser.DisconnectedNodeContext ctx) {
            AstDisconnectedNodeVisitor visitor = new AstDisconnectedNodeVisitor(this.factory, this.environment);
            AstDisconnectedNode disconnectedNode = visitor.visitDisconnectedNode(ctx);
            if (disconnectedNode != null) {
                this.childInfos().add(disconnectedNode.getRegionInfo());
            }
            return disconnectedNode;
        }

        @Override
        public AstOpenedNode visitOpenedNode(RobotParser.OpenedNodeContext ctx) {
            AstOpenedNodeVisitor visitor = new AstOpenedNodeVisitor(this.factory, this.environment);
            AstOpenedNode openedNode = visitor.visitOpenedNode(ctx);
            if (openedNode != null) {
                this.childInfos().add(openedNode.getRegionInfo());
            }
            return openedNode;
        }

        @Override
        public AstReadConfigNode visitReadConfigNode(RobotParser.ReadConfigNodeContext ctx) {
            AstReadConfigNodeVisitor visitor = new AstReadConfigNodeVisitor(this.factory, this.environment);
            AstReadConfigNode readConfigNode = visitor.visitReadConfigNode(ctx);
            if (readConfigNode != null) {
                this.childInfos().add(readConfigNode.getRegionInfo());
            }
            return readConfigNode;
        }

        @Override
        public AstReadValueNode visitReadNode(RobotParser.ReadNodeContext ctx) {
            AstReadValueNodeVisitor visitor = new AstReadValueNodeVisitor(this.factory, this.environment);
            AstReadValueNode readNode = visitor.visitReadNode(ctx);
            if (readNode != null) {
                this.childInfos().add(readNode.getRegionInfo());
            }
            return readNode;
        }

        @Override
        public AstReadClosedNode visitReadClosedNode(RobotParser.ReadClosedNodeContext ctx) {
            AstReadClosedNodeVisitor visitor = new AstReadClosedNodeVisitor(this.factory, this.environment);
            AstReadClosedNode readClosedNode = visitor.visitReadClosedNode(ctx);
            if (readClosedNode != null) {
                this.childInfos().add(readClosedNode.getRegionInfo());
            }
            return readClosedNode;
        }

        @Override
        public AstUnboundNode visitUnboundNode(RobotParser.UnboundNodeContext ctx) {
            AstUnboundNodeVisitor visitor = new AstUnboundNodeVisitor(this.factory, this.environment);
            AstUnboundNode unboundNode = visitor.visitUnboundNode(ctx);
            if (unboundNode != null) {
                this.childInfos().add(unboundNode.getRegionInfo());
            }
            return unboundNode;
        }

        @Override
        public AstReadAbortedNode visitReadAbortedNode(RobotParser.ReadAbortedNodeContext ctx) {
            AstReadAbortedNodeVisitor visitor = new AstReadAbortedNodeVisitor(this.factory, this.environment);
            AstReadAbortedNode abortedNode = visitor.visitReadAbortedNode(ctx);
            if (abortedNode != null) {
                this.childInfos().add(abortedNode.getRegionInfo());
            }
            return abortedNode;
        }

        @Override
        public AstWriteAbortedNode visitWriteAbortedNode(RobotParser.WriteAbortedNodeContext ctx) {
            AstWriteAbortedNodeVisitor visitor = new AstWriteAbortedNodeVisitor(this.factory, this.environment);
            AstWriteAbortedNode abortedNode = visitor.visitWriteAbortedNode(ctx);
            if (abortedNode != null) {
                this.childInfos().add(abortedNode.getRegionInfo());
            }
            return abortedNode;
        }
    }

    private static class AstBarrierNodeVisitor
    extends AstNodeVisitor<AstBarrierNode> {
        public AstBarrierNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadAwaitNode visitReadAwaitNode(RobotParser.ReadAwaitNodeContext ctx) {
            AstReadAwaitNodeVisitor visitor = new AstReadAwaitNodeVisitor(this.factory, this.environment);
            AstReadAwaitNode readAwaitNode = visitor.visitReadAwaitNode(ctx);
            if (readAwaitNode != null) {
                this.childInfos().add(readAwaitNode.getRegionInfo());
            }
            return readAwaitNode;
        }

        @Override
        public AstReadNotifyNode visitReadNotifyNode(RobotParser.ReadNotifyNodeContext ctx) {
            AstReadNotifyNodeVisitor visitor = new AstReadNotifyNodeVisitor(this.factory, this.environment);
            AstReadNotifyNode readNotifyNode = visitor.visitReadNotifyNode(ctx);
            if (readNotifyNode != null) {
                this.childInfos().add(readNotifyNode.getRegionInfo());
            }
            return readNotifyNode;
        }

        @Override
        public AstWriteAwaitNode visitWriteAwaitNode(RobotParser.WriteAwaitNodeContext ctx) {
            AstWriteAwaitNodeVisitor visitor = new AstWriteAwaitNodeVisitor(this.factory, this.environment);
            AstWriteAwaitNode writeAwaitNode = visitor.visitWriteAwaitNode(ctx);
            if (writeAwaitNode != null) {
                this.childInfos().add(writeAwaitNode.getRegionInfo());
            }
            return writeAwaitNode;
        }

        @Override
        public AstWriteNotifyNode visitWriteNotifyNode(RobotParser.WriteNotifyNodeContext ctx) {
            AstWriteNotifyNodeVisitor visitor = new AstWriteNotifyNodeVisitor(this.factory, this.environment);
            AstWriteNotifyNode writeNotifyNode = visitor.visitWriteNotifyNode(ctx);
            if (writeNotifyNode != null) {
                this.childInfos().add(writeNotifyNode.getRegionInfo());
            }
            return writeNotifyNode;
        }
    }

    private static class AstWriteOptionNodeVisitor
    extends AstNodeVisitor<AstWriteOptionNode> {
        public AstWriteOptionNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstWriteOptionNode visitWriteOptionNode(RobotParser.WriteOptionNodeContext ctx) {
            String optionQName = ctx.optionName().getText();
            TypeInfo<?> optionType = TYPE_SYSTEM.writeOption(optionQName);
            Class<?> expectedType = optionType.getType();
            AstValueVisitor visitor = new AstValueVisitor(this.factory, this.environment, expectedType);
            AstValue optionValue = (AstValue)visitor.visit((ParseTree)ctx);
            this.childInfos().add(optionValue.getRegionInfo());
            this.node = new AstWriteOptionNode();
            ((AstWriteOptionNode)this.node).setOptionType(optionType);
            ((AstWriteOptionNode)this.node).setOptionName(optionQName);
            ((AstWriteOptionNode)this.node).setOptionValue(optionValue);
            ((AstWriteOptionNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstWriteOptionNode)this.node;
        }
    }

    private static class AstReadOptionNodeVisitor
    extends AstNodeVisitor<AstReadOptionNode> {
        public AstReadOptionNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstReadOptionNode visitReadOptionNode(RobotParser.ReadOptionNodeContext ctx) {
            String optionQName = ctx.optionName().getText();
            TypeInfo<?> optionType = TYPE_SYSTEM.readOption(optionQName);
            Class<?> expectedType = optionType.getType();
            AstValueVisitor visitor = new AstValueVisitor(this.factory, this.environment, expectedType);
            AstValue optionValue = (AstValue)visitor.visit((ParseTree)ctx);
            this.childInfos().add(optionValue.getRegionInfo());
            this.node = new AstReadOptionNode();
            ((AstReadOptionNode)this.node).setOptionType(optionType);
            ((AstReadOptionNode)this.node).setOptionName(optionQName);
            ((AstReadOptionNode)this.node).setOptionValue(optionValue);
            ((AstReadOptionNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstReadOptionNode)this.node;
        }
    }

    private static class AstStreamableNodeVisitor
    extends AstNodeVisitor<AstStreamableNode> {
        public AstStreamableNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstBarrierNode visitBarrierNode(RobotParser.BarrierNodeContext ctx) {
            AstBarrierNodeVisitor visitor = new AstBarrierNodeVisitor(this.factory, this.environment);
            AstBarrierNode barrierNode = (AstBarrierNode)visitor.visitBarrierNode(ctx);
            if (barrierNode != null) {
                this.childInfos().add(barrierNode.getRegionInfo());
            }
            return barrierNode;
        }

        @Override
        public AstEventNode visitEventNode(RobotParser.EventNodeContext ctx) {
            AstEventNodeVisitor visitor = new AstEventNodeVisitor(this.factory, this.environment);
            AstEventNode eventNode = (AstEventNode)visitor.visitEventNode(ctx);
            if (eventNode != null) {
                this.childInfos().add(eventNode.getRegionInfo());
            }
            return eventNode;
        }

        @Override
        public AstCommandNode visitCommandNode(RobotParser.CommandNodeContext ctx) {
            AstCommandNodeVisitor visitor = new AstCommandNodeVisitor(this.factory, this.environment);
            AstCommandNode commandNode = (AstCommandNode)visitor.visitCommandNode(ctx);
            if (commandNode != null) {
                this.childInfos().add(commandNode.getRegionInfo());
            }
            return commandNode;
        }

        @Override
        public AstReadOptionNode visitReadOptionNode(RobotParser.ReadOptionNodeContext ctx) {
            AstReadOptionNodeVisitor visitor = new AstReadOptionNodeVisitor(this.factory, this.environment);
            AstReadOptionNode optionNode = visitor.visitReadOptionNode(ctx);
            if (optionNode != null) {
                this.childInfos().add(optionNode.getRegionInfo());
            }
            return optionNode;
        }

        @Override
        public AstWriteOptionNode visitWriteOptionNode(RobotParser.WriteOptionNodeContext ctx) {
            AstWriteOptionNodeVisitor visitor = new AstWriteOptionNodeVisitor(this.factory, this.environment);
            AstWriteOptionNode optionNode = visitor.visitWriteOptionNode(ctx);
            if (optionNode != null) {
                this.childInfos().add(optionNode.getRegionInfo());
            }
            return optionNode;
        }
    }

    private static class AstConnectAbortedNodeVisitor
    extends AstNodeVisitor<AstConnectAbortedNode> {
        public AstConnectAbortedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstConnectAbortedNode visitConnectAbortedNode(RobotParser.ConnectAbortedNodeContext ctx) {
            this.node = new AstConnectAbortedNode();
            super.visitConnectAbortedNode(ctx);
            ((AstConnectAbortedNode)this.node).setRegionInfo(ScriptParseStrategy.asParallelRegion(this.childInfos, ctx));
            return (AstConnectAbortedNode)this.node;
        }
    }

    private static class AstConnectAbortNodeVisitor
    extends AstNodeVisitor<AstConnectAbortNode> {
        public AstConnectAbortNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstConnectAbortNode visitConnectAbortNode(RobotParser.ConnectAbortNodeContext ctx) {
            this.node = new AstConnectAbortNode();
            super.visitConnectAbortNode(ctx);
            ((AstConnectAbortNode)this.node).setRegionInfo(ScriptParseStrategy.asParallelRegion(this.childInfos, ctx));
            return (AstConnectAbortNode)this.node;
        }
    }

    private static class AstConnectNodeVisitor
    extends AstNodeVisitor<AstConnectNode> {
        public AstConnectNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstConnectNode visitConnectNode(RobotParser.ConnectNodeContext ctx) {
            AstLocationVisitor locationVisitor = new AstLocationVisitor(this.factory, this.environment);
            AstValue location = (AstValue)locationVisitor.visit((ParseTree)ctx.connectURI);
            this.node = new AstConnectNode();
            ((AstConnectNode)this.node).setLocation(location);
            super.visitConnectNode(ctx);
            ((AstConnectNode)this.node).setRegionInfo(ScriptParseStrategy.asParallelRegion(this.childInfos, ctx));
            if (ctx.await != null) {
                ((AstConnectNode)this.node).setAwaitName(ctx.await.getText());
            }
            return (AstConnectNode)this.node;
        }

        @Override
        public AstConnectNode visitConnectOption(RobotParser.ConnectOptionContext ctx) {
            String optionQName = ctx.optionName().getText();
            TypeInfo<?> optionType = TYPE_SYSTEM.connectOption(optionQName);
            String optionName = optionType.getName();
            Class<?> expectedType = optionType.getType();
            AstValueVisitor valueVisitor = new AstValueVisitor(this.factory, this.environment, expectedType);
            AstValue optionValue = (AstValue)valueVisitor.visit((ParseTree)ctx.writeValue());
            Map<String, Object> options = ((AstConnectNode)this.node).getOptions();
            options.put(optionName, optionValue);
            return (AstConnectNode)super.visitConnectOption(ctx);
        }

        @Override
        public AstConnectNode visitStreamableNode(RobotParser.StreamableNodeContext ctx) {
            AstStreamableNodeVisitor visitor = new AstStreamableNodeVisitor(this.factory, this.environment);
            AstStreamableNode streamableNode = (AstStreamableNode)visitor.visitStreamableNode(ctx);
            if (streamableNode != null) {
                ((AstConnectNode)this.node).getStreamables().add(streamableNode);
                this.childInfos().add(streamableNode.getRegionInfo());
            }
            return (AstConnectNode)this.node;
        }
    }

    private static class AstRejectedNodeVisitor
    extends AstNodeVisitor<AstRejectedNode> {
        public AstRejectedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstRejectedNode visitRejectedNode(RobotParser.RejectedNodeContext ctx) {
            this.node = new AstRejectedNode();
            if (ctx.text != null) {
                ((AstRejectedNode)this.node).setAcceptName(ctx.text.getText());
            }
            super.visitRejectedNode(ctx);
            ((AstRejectedNode)this.node).setRegionInfo(ScriptParseStrategy.asParallelRegion(this.childInfos, ctx));
            return (AstRejectedNode)this.node;
        }

        @Override
        public AstRejectedNode visitRejectableNode(RobotParser.RejectableNodeContext ctx) {
            AstStreamableNodeVisitor visitor = new AstStreamableNodeVisitor(this.factory, this.environment);
            AstStreamableNode rejectableNode = (AstStreamableNode)visitor.visitRejectableNode(ctx);
            if (rejectableNode != null) {
                ((AstRejectedNode)this.node).getStreamables().add(rejectableNode);
                this.childInfos().add(rejectableNode.getRegionInfo());
            }
            return (AstRejectedNode)this.node;
        }
    }

    private static class AstAcceptedNodeVisitor
    extends AstNodeVisitor<AstAcceptedNode> {
        public AstAcceptedNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstAcceptedNode visitAcceptedNode(RobotParser.AcceptedNodeContext ctx) {
            this.node = new AstAcceptedNode();
            if (ctx.text != null) {
                ((AstAcceptedNode)this.node).setAcceptName(ctx.text.getText());
            }
            super.visitAcceptedNode(ctx);
            ((AstAcceptedNode)this.node).setRegionInfo(ScriptParseStrategy.asParallelRegion(this.childInfos, ctx));
            return (AstAcceptedNode)this.node;
        }

        @Override
        public AstAcceptedNode visitStreamableNode(RobotParser.StreamableNodeContext ctx) {
            AstStreamableNodeVisitor visitor = new AstStreamableNodeVisitor(this.factory, this.environment);
            AstStreamableNode streamableNode = (AstStreamableNode)visitor.visitStreamableNode(ctx);
            if (streamableNode != null) {
                ((AstAcceptedNode)this.node).getStreamables().add(streamableNode);
                this.childInfos().add(streamableNode.getRegionInfo());
            }
            return (AstAcceptedNode)this.node;
        }
    }

    private static class AstAcceptNodeVisitor
    extends AstNodeVisitor<AstAcceptNode> {
        public AstAcceptNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstAcceptNode visitAcceptNode(RobotParser.AcceptNodeContext ctx) {
            AstLocationVisitor locationVisitor = new AstLocationVisitor(this.factory, this.environment);
            AstValue location = (AstValue)locationVisitor.visit((ParseTree)ctx.acceptURI);
            this.node = new AstAcceptNode();
            ((AstAcceptNode)this.node).setLocation(location);
            if (ctx.as != null) {
                ((AstAcceptNode)this.node).setAcceptName(ctx.as.getText());
            }
            if (ctx.notify != null) {
                ((AstAcceptNode)this.node).setNotifyName(ctx.notify.getText());
            }
            super.visitAcceptNode(ctx);
            ((AstAcceptNode)this.node).setRegionInfo(ScriptParseStrategy.asParallelRegion(this.childInfos, ctx));
            return (AstAcceptNode)this.node;
        }

        @Override
        public AstAcceptNode visitAcceptOption(RobotParser.AcceptOptionContext ctx) {
            String optionQName = ctx.optionName().getText();
            TypeInfo<?> optionType = TYPE_SYSTEM.acceptOption(optionQName);
            String optionName = optionType.getName();
            Class<?> expectedType = optionType.getType();
            AstValueVisitor valueVisitor = new AstValueVisitor(this.factory, this.environment, expectedType);
            AstValue optionValue = (AstValue)valueVisitor.visit((ParseTree)ctx.writeValue());
            Map<String, Object> options = ((AstAcceptNode)this.node).getOptions();
            options.put(optionName, optionValue);
            return (AstAcceptNode)super.visitAcceptOption(ctx);
        }

        @Override
        public AstAcceptNode visitServerStreamableNode(RobotParser.ServerStreamableNodeContext ctx) {
            AstStreamableNodeVisitor visitor = new AstStreamableNodeVisitor(this.factory, this.environment);
            AstStreamableNode streamableNode = (AstStreamableNode)visitor.visitServerStreamableNode(ctx);
            if (streamableNode != null) {
                ((AstAcceptNode)this.node).getStreamables().add(streamableNode);
                this.childInfos().add(streamableNode.getRegionInfo());
            }
            return (AstAcceptNode)this.node;
        }
    }

    private static class AstStreamNodeVisitor
    extends AstNodeVisitor<AstStreamNode> {
        public AstStreamNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstAcceptNode visitAcceptNode(RobotParser.AcceptNodeContext ctx) {
            AstAcceptNodeVisitor visitor = new AstAcceptNodeVisitor(this.factory, this.environment);
            AstAcceptNode acceptNode = visitor.visitAcceptNode(ctx);
            if (acceptNode != null) {
                this.childInfos().add(acceptNode.getRegionInfo());
            }
            return acceptNode;
        }

        @Override
        public AstAcceptedNode visitAcceptedNode(RobotParser.AcceptedNodeContext ctx) {
            AstAcceptedNodeVisitor visitor = new AstAcceptedNodeVisitor(this.factory, this.environment);
            AstAcceptedNode acceptedNode = visitor.visitAcceptedNode(ctx);
            if (acceptedNode != null) {
                this.childInfos().add(acceptedNode.getRegionInfo());
            }
            return acceptedNode;
        }

        @Override
        public AstRejectedNode visitRejectedNode(RobotParser.RejectedNodeContext ctx) {
            AstRejectedNodeVisitor visitor = new AstRejectedNodeVisitor(this.factory, this.environment);
            AstRejectedNode rejectedNode = visitor.visitRejectedNode(ctx);
            if (rejectedNode != null) {
                this.childInfos().add(rejectedNode.getRegionInfo());
            }
            return rejectedNode;
        }

        @Override
        public AstConnectNode visitConnectNode(RobotParser.ConnectNodeContext ctx) {
            AstConnectNodeVisitor visitor = new AstConnectNodeVisitor(this.factory, this.environment);
            AstConnectNode connectNode = visitor.visitConnectNode(ctx);
            if (connectNode != null) {
                this.childInfos().add(connectNode.getRegionInfo());
            }
            return connectNode;
        }
    }

    private static class AstPropertyNodeVisitor
    extends AstNodeVisitor<AstPropertyNode> {
        public AstPropertyNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstPropertyNode visitPropertyNode(RobotParser.PropertyNodeContext ctx) {
            AstValueVisitor<Object> visitor = new AstValueVisitor<Object>(this.factory, this.environment, Object.class);
            AstValue value = (AstValue)visitor.visit((ParseTree)ctx.value);
            this.childInfos().add(value.getRegionInfo());
            this.node = new AstPropertyNode();
            ((AstPropertyNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            ((AstPropertyNode)this.node).setPropertyName(ctx.name.getText());
            ((AstPropertyNode)this.node).setPropertyValue(value);
            ((AstPropertyNode)this.node).setEnvironment(this.environment);
            return (AstPropertyNode)this.node;
        }
    }

    private static class AstScriptNodeVisitor
    extends AstNodeVisitor<AstScriptNode> {
        public AstScriptNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        @Override
        public AstScriptNode visitScriptNode(RobotParser.ScriptNodeContext ctx) {
            this.node = new AstScriptNode();
            super.visitScriptNode(ctx);
            ((AstScriptNode)this.node).setRegionInfo(ScriptParseStrategy.asSequentialRegion(this.childInfos, ctx));
            return (AstScriptNode)this.node;
        }

        @Override
        public AstScriptNode visitPropertyNode(RobotParser.PropertyNodeContext ctx) {
            AstPropertyNodeVisitor visitor = new AstPropertyNodeVisitor(this.factory, this.environment);
            AstPropertyNode propertyNode = visitor.visitPropertyNode(ctx);
            if (propertyNode != null) {
                ((AstScriptNode)this.node).getProperties().add(propertyNode);
                this.childInfos().add(propertyNode.getRegionInfo());
            }
            return (AstScriptNode)this.node;
        }

        @Override
        public AstScriptNode visitStreamNode(RobotParser.StreamNodeContext ctx) {
            AstStreamNodeVisitor visitor = new AstStreamNodeVisitor(this.factory, this.environment);
            AstStreamNode streamNode = (AstStreamNode)visitor.visitStreamNode(ctx);
            if (streamNode != null) {
                ((AstScriptNode)this.node).getStreams().add(streamNode);
                this.childInfos().add(streamNode.getRegionInfo());
            }
            return (AstScriptNode)this.node;
        }
    }

    private static class AstNodeVisitor<T extends AstNode>
    extends AstVisitor<T> {
        protected T node;

        public AstNodeVisitor(ExpressionFactory factory, ExpressionContext environment) {
            super(factory, environment);
        }

        protected T defaultResult() {
            return this.node;
        }
    }

    private static class AstVisitor<T>
    extends RobotBaseVisitor<T> {
        private static final List<RegionInfo> EMPTY_CHILDREN = Collections.emptyList();
        protected List<RegionInfo> childInfos = EMPTY_CHILDREN;
        protected final ExpressionFactory factory;
        protected final ExpressionContext environment;

        protected AstVisitor(ExpressionFactory factory, ExpressionContext environment) {
            this.factory = factory;
            this.environment = environment;
        }

        protected List<RegionInfo> childInfos() {
            if (this.childInfos == EMPTY_CHILDREN) {
                this.childInfos = new LinkedList<RegionInfo>();
            }
            return this.childInfos;
        }
    }
}

