/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.parser.types;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.kaazing.k3po.lang.internal.parser.types.DefaultTypeSystem;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;
import org.kaazing.k3po.lang.types.TypeInfo;
import org.kaazing.k3po.lang.types.TypeSystemSpi;

public final class TypeSystem {
    private final Map<String, TypeInfo<?>> acceptOptions;
    private final Map<String, TypeInfo<?>> connectOptions;
    private final Map<String, TypeInfo<?>> readOptions;
    private final Map<String, TypeInfo<?>> writeOptions;
    private final Map<String, StructuredTypeInfo> readConfigs;
    private final Map<String, StructuredTypeInfo> writeConfigs;

    private TypeSystem(Iterable<TypeSystemSpi> typeSystems) {
        TreeMap acceptOptions = new TreeMap();
        TreeMap connectOptions = new TreeMap();
        TreeMap readOptions = new TreeMap();
        TreeMap writeOptions = new TreeMap();
        TreeMap<String, StructuredTypeInfo> readConfigs = new TreeMap<String, StructuredTypeInfo>();
        TreeMap<String, StructuredTypeInfo> writeConfigs = new TreeMap<String, StructuredTypeInfo>();
        for (TypeSystemSpi typeSystem : typeSystems) {
            Function<TypeInfo, String> namer = t -> String.format("%s:%s", typeSystem.getName(), t.getName());
            Function<StructuredTypeInfo, String> structNamer = t -> String.format("%s:%s", typeSystem.getName(), t.getName());
            TypeSystem.populate(namer, acceptOptions, typeSystem.acceptOptions());
            TypeSystem.populate(namer, connectOptions, typeSystem.connectOptions());
            TypeSystem.populate(namer, readOptions, typeSystem.readOptions());
            TypeSystem.populate(namer, writeOptions, typeSystem.writeOptions());
            TypeSystem.populate(structNamer, readConfigs, typeSystem.readConfigs());
            TypeSystem.populate(structNamer, writeConfigs, typeSystem.writeConfigs());
        }
        Function<TypeInfo, String> defaultNamer = t -> t.getName();
        Function<StructuredTypeInfo, String> defaultStructNamer = t -> t.getName();
        DefaultTypeSystem defaultTypeSystem = new DefaultTypeSystem();
        TypeSystem.populate(defaultNamer, acceptOptions, defaultTypeSystem.acceptOptions());
        TypeSystem.populate(defaultNamer, connectOptions, defaultTypeSystem.connectOptions());
        TypeSystem.populate(defaultNamer, readOptions, defaultTypeSystem.readOptions());
        TypeSystem.populate(defaultNamer, writeOptions, defaultTypeSystem.writeOptions());
        TypeSystem.populate(defaultStructNamer, readConfigs, defaultTypeSystem.readConfigs());
        TypeSystem.populate(defaultStructNamer, writeConfigs, defaultTypeSystem.writeConfigs());
        this.acceptOptions = acceptOptions;
        this.connectOptions = connectOptions;
        this.readOptions = readOptions;
        this.writeOptions = writeOptions;
        this.readConfigs = readConfigs;
        this.writeConfigs = writeConfigs;
    }

    public TypeInfo<?> acceptOption(String optionName) {
        return TypeSystem.verifyOption(this.acceptOptions.get(optionName), optionName);
    }

    public TypeInfo<?> connectOption(String optionName) {
        return TypeSystem.verifyOption(this.connectOptions.get(optionName), optionName);
    }

    public TypeInfo<?> readOption(String optionName) {
        return TypeSystem.verifyOption(this.readOptions.get(optionName), optionName);
    }

    public TypeInfo<?> writeOption(String optionName) {
        return TypeSystem.verifyOption(this.writeOptions.get(optionName), optionName);
    }

    public StructuredTypeInfo readConfig(String configName) {
        return TypeSystem.verifyConfig(this.readConfigs.get(configName), configName);
    }

    public StructuredTypeInfo writeConfig(String configName) {
        return TypeSystem.verifyConfig(this.writeConfigs.get(configName), configName);
    }

    private static <T> T verifyOption(T value, String optionName) {
        if (value == null) {
            throw new IllegalArgumentException("Unrecognized option: " + optionName);
        }
        return value;
    }

    private static <T> T verifyConfig(T value, String optionName) {
        if (value == null) {
            throw new IllegalArgumentException("Unrecognized config: " + optionName);
        }
        return value;
    }

    private static <T> void populate(Function<T, String> qualifiedNamer, Map<String, T> optionsByName, Set<T> options) {
        for (T option : options) {
            String optionQName = qualifiedNamer.apply(option);
            optionsByName.put(optionQName, option);
        }
    }

    public static final TypeSystem newInstance() {
        return new TypeSystem(ServiceLoader.load(TypeSystemSpi.class));
    }
}

