/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.regex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.regex.NamedGroupMatcher;
import org.kaazing.k3po.lang.regex.RegexBaseListener;
import org.kaazing.k3po.lang.regex.RegexLexer;
import org.kaazing.k3po.lang.regex.RegexParser;

public class NamedGroupPattern {
    private final Pattern pattern;
    private final List<String> groupNames;

    public static NamedGroupPattern compile(String regexWithGroupNames) {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(regexWithGroupNames.getBytes(StandardCharsets.UTF_8));
            ANTLRInputStream ais = new ANTLRInputStream((InputStream)input);
            RegexLexer lexer = new RegexLexer((CharStream)ais);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            RegexParser parser = new RegexParser((TokenStream)tokens);
            parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            final ArrayList<String> groupNames = new ArrayList<String>();
            parser.addParseListener(new RegexBaseListener(){

                @Override
                public void exitGroupN(RegexParser.GroupNContext ctx) {
                    Token captureVar = ctx.capture;
                    if (captureVar != null) {
                        String capture = captureVar.getText();
                        String groupName = capture.substring(2, capture.length() - 1);
                        groupNames.add(groupName);
                    }
                }
            });
            RegexParser.LiteralContext literal = parser.literal();
            String regex = literal.regex.getText();
            return new NamedGroupPattern(Pattern.compile(regex), groupNames);
        }
        catch (IOException ioe) {
            PatternSyntaxException pse = new PatternSyntaxException("I/O exception", regexWithGroupNames, 0);
            pse.initCause(ioe);
            throw pse;
        }
        catch (ParseCancellationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException re = (RecognitionException)cause;
                PatternSyntaxException pse = new PatternSyntaxException("Unexpected type", regexWithGroupNames, re.getInputStream().index());
                pse.initCause(re);
                throw pse;
            }
            throw e;
        }
        catch (RecognitionException re) {
            PatternSyntaxException pse = new PatternSyntaxException("Unexpected type", regexWithGroupNames, re.getInputStream().index());
            pse.initCause(re);
            throw pse;
        }
    }

    NamedGroupPattern(Pattern pattern, List<String> groupNames) {
        this.pattern = pattern;
        this.groupNames = groupNames;
        int groupNamesSize = groupNames.size();
        if (groupNamesSize != 0 && pattern.matcher("").groupCount() != groupNamesSize) {
            throw new PatternSyntaxException("Inconsistant named group count. The number of named groups must match the number of groups in the pattern.", pattern.toString(), -1);
        }
    }

    public NamedGroupMatcher matcher(CharSequence input) {
        return new NamedGroupMatcher(this.pattern.matcher(input), this.groupNames);
    }

    public int hashCode() {
        return this.pattern.hashCode() ^ this.groupNames.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NamedGroupPattern && this.equals((NamedGroupPattern)obj);
    }

    protected boolean equals(NamedGroupPattern that) {
        return AstUtil.equivalent(this.pattern, that.pattern) && AstUtil.equivalent(this.groupNames, that.groupNames);
    }

    public String pattern() {
        return this.pattern.pattern();
    }

    public String toString() {
        return this.pattern.toString();
    }
}

