/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.types;

import java.util.List;
import java.util.Objects;
import org.kaazing.k3po.lang.types.TypeInfo;

public final class StructuredTypeInfo {
    private final String qualifiedName;
    private final String name;
    private final List<TypeInfo<?>> namedFields;
    private final int anonymousFields;

    public StructuredTypeInfo(String scope, String name, List<TypeInfo<?>> namedFields, int anonymousFields) {
        this.qualifiedName = String.format("%s:%s", scope, name);
        this.name = name;
        this.namedFields = namedFields;
        this.anonymousFields = anonymousFields;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public List<TypeInfo<?>> getNamedFields() {
        return this.namedFields;
    }

    public int getAnonymousFields() {
        return this.anonymousFields;
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        if (this.name != null) {
            hashCode <<= 4;
            hashCode ^= this.name.hashCode();
        }
        if (this.namedFields != null) {
            hashCode <<= 4;
            hashCode ^= this.namedFields.hashCode();
        }
        hashCode <<= 4;
        return hashCode ^= this.anonymousFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeInfo)) {
            return false;
        }
        StructuredTypeInfo that = (StructuredTypeInfo)o;
        return this.anonymousFields == that.anonymousFields && Objects.equals(this.name, that.name) && Objects.equals(this.namedFields, that.namedFields);
    }

    public String toString() {
        return String.format("%s[%s %s %d]", this.getClass().getSimpleName(), this.qualifiedName, this.namedFields, this.anonymousFields);
    }
}

