/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RegionInfo {
    private static final List<RegionInfo> EMPTY_CHILDREN = Collections.emptyList();
    public final List<RegionInfo> children;
    public final int start;
    public final int end;
    public final Kind kind;

    public static RegionInfo newParallel(int start, int end) {
        return RegionInfo.newParallel(EMPTY_CHILDREN, start, end);
    }

    public static RegionInfo newParallel(List<RegionInfo> children, int start, int end) {
        return new RegionInfo(Kind.PARALLEL, children, start, end);
    }

    public static RegionInfo newSequential(int start, int end) {
        return RegionInfo.newSequential(EMPTY_CHILDREN, start, end);
    }

    public static RegionInfo newSequential(List<RegionInfo> children, int start, int end) {
        return new RegionInfo(Kind.SEQUENTIAL, children, start, end);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.start, this.end);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RegionInfo && this.equalTo((RegionInfo)obj);
    }

    public int size() {
        return this.end - this.start;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.appendString(0, sb);
        return sb.toString();
    }

    private RegionInfo(Kind kind, List<RegionInfo> children, int start, int end) {
        this.kind = Objects.requireNonNull(kind);
        this.children = Objects.requireNonNull(children);
        if (end < start) {
            throw new IllegalArgumentException("end < start");
        }
        this.start = start;
        this.end = end;
    }

    private void appendString(int level, StringBuffer sb) {
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(String.format("[%d,%d) %s", new Object[]{this.start, this.end, this.kind}));
        for (RegionInfo child : this.children) {
            sb.append('\n');
            child.appendString(level + 1, sb);
        }
    }

    private boolean equalTo(RegionInfo that) {
        return this.start == that.start && this.end == that.end && Objects.equals(this.children, that.children);
    }

    public static enum Kind {
        PARALLEL,
        SEQUENTIAL;

    }
}

