/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.kaazing.k3po.lang.internal.ast.AstCommandNode;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;

public class AstReadAdviseNode
extends AstCommandNode {
    private StructuredTypeInfo type;
    private Collection<AstValue<?>> values;
    private Map<String, AstValue<?>> valuesByName = new LinkedHashMap();

    public AstReadAdviseNode() {
        this.values = new LinkedList();
    }

    public void setType(StructuredTypeInfo type) {
        this.type = type;
    }

    public StructuredTypeInfo getType() {
        return this.type;
    }

    public void setValue(String name, AstValue<?> value) {
        this.valuesByName.put(name, value);
    }

    public AstValue<?> getValue(String name) {
        return this.valuesByName.get(name);
    }

    public void addValue(AstValue<?> value) {
        this.values.add(value);
    }

    public Collection<AstValue<?>> getValues() {
        return this.values;
    }

    public AstValue<?> getValue() {
        if (this.valuesByName.isEmpty()) {
            switch (this.values.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.values.iterator().next();
                }
            }
        }
        throw new IllegalStateException("Multiple values available, yet assuming only one value");
    }

    @Override
    public <R, P> R accept(AstNode.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        if (this.type != null) {
            hashCode <<= 4;
            hashCode ^= this.type.hashCode();
        }
        if (this.valuesByName != null) {
            hashCode <<= 4;
            hashCode ^= this.valuesByName.hashCode();
        }
        return hashCode;
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstReadAdviseNode && this.equalTo((AstReadAdviseNode)that);
    }

    protected boolean equalTo(AstReadAdviseNode that) {
        return AstUtil.equivalent(this.type, that.type) && AstUtil.equivalent(this.values, that.values) && AstUtil.equivalent(this.valuesByName, that.valuesByName);
    }

    @Override
    protected void describe(StringBuilder buf) {
        super.describe(buf);
        buf.append("read advise ").append(this.type);
        for (Map.Entry<String, AstValue<?>> entry : this.valuesByName.entrySet()) {
            String name = entry.getKey();
            AstValue<?> value = entry.getValue();
            buf.append(' ').append(name).append('=').append(value);
        }
        for (AstValue astValue : this.values) {
            buf.append(' ').append(astValue);
        }
        buf.append('\n');
    }
}

