/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.kaazing.k3po.lang.internal.ast.AstEventNode;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.types.StructuredTypeInfo;

public class AstReadAdvisedNode
extends AstEventNode {
    private StructuredTypeInfo type;
    private Map<String, AstValueMatcher> matchersByName = new LinkedHashMap<String, AstValueMatcher>();
    private Collection<AstValueMatcher> matchers = new LinkedList<AstValueMatcher>();
    private boolean missing;

    public void setType(StructuredTypeInfo type) {
        this.type = type;
    }

    public StructuredTypeInfo getType() {
        return this.type;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public AstValueMatcher getMatcher() {
        if (this.matchersByName.isEmpty()) {
            switch (this.matchers.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.matchers.iterator().next();
                }
            }
        }
        throw new IllegalStateException("Multiple values available, yet assuming only one value");
    }

    public Collection<AstValueMatcher> getMatchers() {
        return this.matchers;
    }

    public AstValueMatcher getMatcher(String name) {
        return this.matchersByName.get(name);
    }

    public void setMatcher(String name, AstValueMatcher matcher) {
        this.matchersByName.put(name, matcher);
    }

    public void addMatcher(AstValueMatcher matcher) {
        this.matchers.add(matcher);
    }

    public void addMatchers(Collection<AstValueMatcher> matchers) {
        this.matchers.addAll(matchers);
    }

    @Override
    public <R, P> R accept(AstNode.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        if (this.type != null) {
            hashCode <<= 4;
            hashCode ^= this.type.hashCode();
        }
        if (this.matchers != null) {
            hashCode <<= 4;
            hashCode ^= this.matchers.hashCode();
        }
        if (this.matchersByName != null) {
            hashCode <<= 4;
            hashCode ^= this.matchersByName.hashCode();
        }
        hashCode <<= 4;
        return hashCode ^= Boolean.hashCode(this.missing);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstReadAdvisedNode && this.equalTo((AstReadAdvisedNode)that);
    }

    protected boolean equalTo(AstReadAdvisedNode that) {
        return this.missing == that.missing && Objects.equals(this.type, that.type) && Objects.equals(this.matchers, that.matchers) && Objects.equals(this.matchersByName, that.matchersByName);
    }

    @Override
    protected void describe(StringBuilder buf) {
        super.describe(buf);
        buf.append("read advised ").append(this.type);
        for (Map.Entry<String, AstValueMatcher> entry : this.matchersByName.entrySet()) {
            String name = entry.getKey();
            AstValueMatcher matcher = entry.getValue();
            buf.append(' ').append(name).append('=').append(matcher);
        }
        for (AstValueMatcher value : this.matchers) {
            buf.append(' ').append(value);
        }
        buf.append('\n');
    }
}

