/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast;

import java.util.LinkedList;
import java.util.List;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstPropertyNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.AstStreamNode;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;

public class AstScriptNode
extends AstNode {
    private List<AstPropertyNode> properties;
    private List<AstStreamNode> streams;

    public List<AstPropertyNode> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedList<AstPropertyNode>();
        }
        return this.properties;
    }

    public List<AstStreamNode> getStreams() {
        if (this.streams == null) {
            this.streams = new LinkedList<AstStreamNode>();
        }
        return this.streams;
    }

    @Override
    public <R, P> R accept(AstNode.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        if (this.streams != null) {
            hashCode <<= 4;
            hashCode ^= this.streams.hashCode();
        }
        return hashCode;
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstScriptNode && this.equalTo((AstScriptNode)that);
    }

    protected boolean equalTo(AstScriptNode that) {
        return AstUtil.equivalent(this.streams, that.streams);
    }

    @Override
    protected void describe(StringBuilder buf) {
        if (this.properties != null) {
            for (AstPropertyNode property : this.properties) {
                property.describe(buf);
            }
        }
        if (this.streams != null) {
            for (AstStreamNode stream : this.streams) {
                stream.describe(buf);
            }
        }
    }
}

