/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast;

import java.util.ArrayList;
import java.util.List;
import org.kaazing.k3po.lang.internal.ast.AstCommandNode;
import org.kaazing.k3po.lang.internal.ast.AstNode;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public class AstWriteValueNode
extends AstCommandNode {
    private List<AstValue<?>> values;

    public List<AstValue<?>> getValues() {
        return this.values;
    }

    public void setValues(List<AstValue<?>> values) {
        this.values = values;
    }

    public void addValue(AstValue<?> value) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(value);
    }

    @Override
    public <R, P> R accept(AstNode.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        int hashCode = this.getClass().hashCode();
        if (this.values != null) {
            hashCode <<= 4;
            hashCode ^= this.values.hashCode();
        }
        return hashCode;
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstWriteValueNode && this.equalTo((AstWriteValueNode)that);
    }

    protected boolean equalTo(AstWriteValueNode that) {
        return AstUtil.equivalent(this.values, that.values);
    }

    @Override
    protected void describe(StringBuilder buf) {
        super.describe(buf);
        buf.append("write");
        for (AstValue<?> val : this.values) {
            buf.append(" " + val);
        }
        buf.append("\n");
    }
}

