/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.matcher;

import javax.el.ValueExpression;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;

public final class AstExpressionMatcher
extends AstValueMatcher {
    private final ValueExpression value;
    private final ExpressionContext environment;

    public AstExpressionMatcher(ValueExpression value, ExpressionContext environment) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
        this.environment = environment;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValueMatcher.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return this.value.hashCode();
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstExpressionMatcher && this.equalTo((AstExpressionMatcher)that);
    }

    protected boolean equalTo(AstExpressionMatcher that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append(String.format("(%s)%s", this.value.getExpectedType().getSimpleName(), this.value.getExpressionString()));
    }

    public ExpressionContext getEnvironment() {
        return this.environment;
    }
}

