/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.matcher;

import java.util.Objects;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.matcher.AstValueMatcher;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;

public final class AstNumberMatcher
extends AstValueMatcher {
    private final Number value;

    public AstNumberMatcher(Number value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValueMatcher.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return Objects.hashCode(this.value);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstNumberMatcher && this.equalTo((AstNumberMatcher)that);
    }

    protected boolean equalTo(AstNumberMatcher that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append(this.value.toString());
        if (this.value instanceof Long) {
            buf.append('L');
        }
    }
}

