/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.value;

import javax.el.ValueExpression;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;
import org.kaazing.k3po.lang.internal.el.ExpressionFactoryUtils;

public final class AstExpressionValue<T>
extends AstValue<T> {
    private final ValueExpression expression;
    private final ExpressionContext environment;

    public AstExpressionValue(ValueExpression expression, ExpressionContext environment) {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        this.expression = expression;
        this.environment = environment;
    }

    @Override
    public T getValue() {
        return ExpressionFactoryUtils.synchronizedValue(this.expression, this.environment, this.expression.getExpectedType());
    }

    public <R> R getValue(Class<R> expectedType) {
        return ExpressionFactoryUtils.synchronizedValue(this.expression, this.environment, expectedType);
    }

    public ValueExpression getExpression() {
        return this.expression;
    }

    public ExpressionContext getEnvironment() {
        return this.environment;
    }

    @Override
    public <R, P> R accept(AstValue.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return this.expression.hashCode();
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstExpressionValue && this.equalTo((AstExpressionValue)that);
    }

    protected boolean equalTo(AstExpressionValue<?> that) {
        return AstUtil.equivalent(this.expression, that.expression);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append(String.format("(%s)%s", this.expression.getExpectedType().getSimpleName(), this.expression.getExpressionString()));
    }
}

