/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.value;

import java.util.Objects;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public final class AstLiteralByteValue
extends AstValue<Byte> {
    private final byte value;

    public AstLiteralByteValue(Byte value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValue.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return Byte.hashCode(this.value);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstLiteralByteValue && this.equalTo((AstLiteralByteValue)that);
    }

    protected boolean equalTo(AstLiteralByteValue that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append(String.format("%02x", this.value));
    }

    public static String toString(byte value) {
        return Byte.toString(value);
    }
}

