/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.value;

import java.util.Arrays;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public final class AstLiteralBytesValue
extends AstValue<byte[]> {
    private final byte[] value;

    public AstLiteralBytesValue(byte[] value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValue.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return Arrays.hashCode(this.value);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstLiteralBytesValue && this.equalTo((AstLiteralBytesValue)that);
    }

    protected boolean equalTo(AstLiteralBytesValue that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        AstLiteralBytesValue.describe(buf, this.value);
    }

    public static String toString(byte[] value) {
        StringBuilder buf = new StringBuilder();
        AstLiteralBytesValue.describe(buf, value);
        return buf.toString();
    }

    private static void describe(StringBuilder buf, byte[] value) {
        if (value == null || value.length == 0) {
            buf.append("[]");
        } else {
            for (byte b : value) {
                buf.append(String.format(" 0x%02x", b));
            }
            buf.setCharAt(0, '[');
            buf.append(']');
        }
    }
}

