/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.ast.value;

import java.util.Objects;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.util.AstUtil;
import org.kaazing.k3po.lang.internal.ast.value.AstValue;

public final class AstLiteralShortValue
extends AstValue<Short> {
    private final short value;

    public AstLiteralShortValue(Short value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AstValue.Visitor<R, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    protected int hashTo() {
        return Short.hashCode(this.value);
    }

    @Override
    protected boolean equalTo(AstRegion that) {
        return that instanceof AstLiteralShortValue && this.equalTo((AstLiteralShortValue)that);
    }

    protected boolean equalTo(AstLiteralShortValue that) {
        return AstUtil.equivalent(this.value, that.value);
    }

    @Override
    protected void describe(StringBuilder buf) {
        buf.append(String.format("%04x", this.value));
    }

    public static String toString(short value) {
        return Short.toString(value);
    }
}

