/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.lang.internal.parser;

import java.util.List;
import javax.el.ExpressionFactory;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.AstRegion;
import org.kaazing.k3po.lang.internal.ast.AstScriptNode;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;
import org.kaazing.k3po.lang.internal.el.ExpressionFactoryUtils;
import org.kaazing.k3po.lang.internal.parser.ScriptParseException;
import org.kaazing.k3po.lang.internal.parser.ScriptParseStrategy;
import org.kaazing.k3po.lang.internal.parser.ScriptParser;
import org.kaazing.k3po.lang.parser.v2.RobotLexer;
import org.kaazing.k3po.lang.parser.v2.RobotParser;

public class ScriptParserImpl
implements ScriptParser {
    private final ExpressionFactory factory;
    private final ExpressionContext context;

    public ScriptParserImpl() {
        this(ExpressionFactoryUtils.newExpressionFactory(), new ExpressionContext());
    }

    public ScriptParserImpl(ExpressionFactory factory, ExpressionContext context) {
        this.factory = factory;
        this.context = context;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.factory;
    }

    public ExpressionContext getExpressionContext() {
        return this.context;
    }

    @Override
    public AstScriptNode parse(String input) throws ScriptParseException {
        try {
            return this.parseWithStrategy(input, ScriptParseStrategy.SCRIPT);
        }
        catch (Exception e) {
            throw new ScriptParseException(e);
        }
    }

    public <T extends AstRegion> T parseWithStrategy(String input, ScriptParseStrategy<T> strategy) throws ScriptParseException {
        AstRegion result = null;
        int newStart = 0;
        int newEnd = input.length();
        CodePointCharStream ais = CharStreams.fromString((String)input);
        RobotLexer lexer = new RobotLexer((CharStream)ais);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        RobotParser parser = new RobotParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            result = (AstRegion)strategy.parse(parser, this.factory, this.context);
            RegionInfo regionInfo = result.getRegionInfo();
            List<RegionInfo> newChildren = regionInfo.children;
            switch (regionInfo.kind) {
                case SEQUENTIAL: {
                    result.setRegionInfo(RegionInfo.newSequential(newChildren, newStart, newEnd));
                    break;
                }
                case PARALLEL: {
                    result.setRegionInfo(RegionInfo.newParallel(newChildren, newStart, newEnd));
                }
            }
        }
        catch (ParseCancellationException pce) {
            Throwable cause = pce.getCause();
            if (cause instanceof RecognitionException) {
                RecognitionException re = (RecognitionException)cause;
                throw this.createScriptParseException(parser, re);
            }
            throw pce;
        }
        catch (RecognitionException re) {
            throw this.createScriptParseException(parser, re);
        }
        return (T)result;
    }

    private ScriptParseException createScriptParseException(RobotParser parser, RecognitionException re) {
        if (re instanceof NoViableAltException) {
            return this.createScriptParseException(parser, (NoViableAltException)re);
        }
        Token token = re.getOffendingToken();
        String desc = String.format("line %d:%d: ", token.getLine(), token.getCharPositionInLine());
        String tokenText = token.getText();
        String msg = null;
        if (tokenText == null) {
            msg = "error: end of input";
        } else {
            desc = String.format("%s'%s'", desc, tokenText);
            String unexpectedTokenName = token.getType() != -1 ? parser.getTokenNames()[token.getType()] : parser.getTokenNames()[0];
            msg = String.format("error: unexpected keyword '%s'", tokenText);
        }
        return new ScriptParseException(msg, re);
    }

    private ScriptParseException createScriptParseException(RobotParser parser, NoViableAltException nvae) {
        String desc = String.format("line %d:%d: ", nvae.getStartToken().getLine(), nvae.getOffendingToken().getCharPositionInLine());
        String msg = String.format("%sunexpected character: '%s'", desc, this.escapeChar(nvae.getOffendingToken().getText().charAt(0)));
        return new ScriptParseException(msg);
    }

    private String escapeChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return Character.toString(c);
    }
}

