/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.jexmec.ctor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.kantega.jexmec.PluginLoader;
import org.kantega.jexmec.ServiceKey;
import org.kantega.jexmec.ServiceLocator;
import org.kantega.jexmec.ctor.ClassLocator;
import org.kantega.jexmec.ctor.InvalidPluginException;
import org.kantega.jexmec.ctor.NamedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInjectionPluginLoader<P>
implements PluginLoader<P> {
    public List<P> loadPlugins(Class<P> pluginClass, ClassLoader classLoader, ServiceLocator serviceLocator) {
        ClassLocator<Class<P>> classLocator = this.createPluginClassLocator(pluginClass);
        ArrayList<P> plugins = new ArrayList<P>();
        List<Class<P>> pluginClasses = classLocator.locateClasses(classLoader);
        for (Class<P> clazz : pluginClasses) {
            if (!pluginClass.isAssignableFrom(clazz)) {
                throw new InvalidPluginException("Plugin class " + clazz.getName() + " is not an instance of " + pluginClass.getName(), clazz);
            }
            if (clazz.getDeclaredConstructors().length != 1) {
                throw new InvalidPluginException("Plugin class " + clazz.getName() + " must have exactly one constructor", clazz);
            }
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            Object[] params = this.getConstructorParameters(constructor, serviceLocator);
            try {
                P plugin = pluginClass.cast(constructor.newInstance(params));
                plugins.add(plugin);
            }
            catch (InstantiationException e) {
                String msg = "Plugin class " + clazz.getName() + " is an " + (clazz.isInterface() ? "interface" : "abstract class");
                throw new InvalidPluginException(msg, e, clazz);
            }
            catch (IllegalAccessException e) {
                throw new InvalidPluginException("Plugin class " + clazz.getName() + " or its constructor has an illegal access modifier", e, clazz);
            }
            catch (InvocationTargetException e) {
                throw new InvalidPluginException("Plugin class " + clazz.getName() + " threw an exeception during construction ", e, clazz);
            }
        }
        return plugins;
    }

    protected ClassLocator<Class<P>> createPluginClassLocator(Class<P> pluginClass) {
        return new ClassLocator<Class<P>>(pluginClass, "simple.txt");
    }

    public void unloadPlugins(ClassLoader classLoader) {
    }

    public void start() {
    }

    public void stop() {
    }

    private Object[] getConstructorParameters(Constructor constructor, ServiceLocator serviceLocator) {
        Object[] params = new Object[constructor.getParameterTypes().length];
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> paramClass = constructor.getParameterTypes()[i];
            if (paramClass == NamedService.class) {
                Type[] genericParameterTypes = constructor.getGenericParameterTypes();
                ParameterizedType type = (ParameterizedType)genericParameterTypes[i];
                params[i] = new SimpleNamedService(serviceLocator, (Class)type.getActualTypeArguments()[0]);
                continue;
            }
            if (!serviceLocator.getServiceKeys().contains(ServiceKey.by(paramClass))) {
                throw new InvalidPluginException("Plugin  class " + constructor.getDeclaringClass() + " has an illegal constructor. Parameter " + i + " of type " + paramClass.getName() + " could not be resolved to an application service", constructor.getDeclaringClass());
            }
            params[i] = serviceLocator.lookupService(ServiceKey.by(paramClass));
        }
        return params;
    }

    private static class SimpleNamedService
    implements NamedService {
        private final ServiceLocator serviceLocator;
        private final Class serviceClass;

        SimpleNamedService(ServiceLocator serviceLocator, Class serviceClass) {
            this.serviceLocator = serviceLocator;
            this.serviceClass = serviceClass;
        }

        public Object get(String name) {
            return this.serviceLocator.lookupService(ServiceKey.by((Class)this.serviceClass, (String)name));
        }
    }
}

