/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kefirsf.bb.DomConfigurationFactory;
import org.kefirsf.bb.TextProcessorFactoryException;
import org.kefirsf.bb.conf.Configuration;
import org.kefirsf.bb.util.Exceptions;
import org.kefirsf.bb.util.Utils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigurationFactory {
    private static final String DEFAULT_CONFIGURATION = "org/kefirsf/bb/default";
    private static final String DEFAULT_USER_CONFIGURATION = "kefirbb";
    private static final String CONFIGURATION_EXTENSION = ".xml";
    public static final String DEFAULT_USER_CONFIGURATION_FILE = "kefirbb.xml";
    public static final String DEFAULT_CONFIGURATION_FILE = "org/kefirsf/bb/default.xml";
    public static final String DEFAULT_PROPERTIES_FILE = "kefirbb.properties";
    public static final String DEFAULT_PROPERTIES_XML_FILE = "kefirbb.properties.xml";
    private final DomConfigurationFactory domConfigurationFactory = DomConfigurationFactory.getInstance();
    private static final ConfigurationFactory instance = new ConfigurationFactory();

    private ConfigurationFactory() {
    }

    public static ConfigurationFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration create() {
        Configuration configuration;
        try {
            block20: {
                InputStream stream = null;
                try {
                    stream = Utils.openResourceStream(DEFAULT_USER_CONFIGURATION_FILE);
                    if (stream == null) {
                        stream = Utils.openResourceStream(DEFAULT_CONFIGURATION_FILE);
                    }
                    if (stream != null) {
                        configuration = this.create(stream);
                        break block20;
                    }
                    throw new TextProcessorFactoryException("Can't find or open default configuration resource.");
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            Properties properties = new Properties();
            InputStream propertiesStream = null;
            try {
                propertiesStream = Utils.openResourceStream(DEFAULT_PROPERTIES_FILE);
                if (propertiesStream != null) {
                    properties.load(propertiesStream);
                }
            }
            finally {
                if (propertiesStream != null) {
                    propertiesStream.close();
                }
            }
            InputStream xmlPropertiesStream = null;
            try {
                xmlPropertiesStream = Utils.openResourceStream(DEFAULT_PROPERTIES_XML_FILE);
                if (xmlPropertiesStream != null) {
                    properties.loadFromXML(xmlPropertiesStream);
                }
            }
            finally {
                if (xmlPropertiesStream != null) {
                    xmlPropertiesStream.close();
                }
            }
            if (!properties.isEmpty()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.putAll(configuration.getParams());
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    Object key = entry.getKey();
                    if (key == null) continue;
                    params.put(key.toString(), entry.getValue());
                }
                configuration.setParams(params);
            }
        }
        catch (IOException e) {
            throw new TextProcessorFactoryException(e);
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration createFromResource(String resourceName) {
        Configuration configuration;
        block7: {
            Exceptions.nullArgument("resourceName", resourceName);
            try {
                InputStream stream = null;
                try {
                    stream = Utils.openResourceStream(resourceName);
                    if (stream != null) {
                        configuration = this.create(stream);
                        break block7;
                    }
                    throw new TextProcessorFactoryException("Can't find or open resource \"" + resourceName + "\".");
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new TextProcessorFactoryException(e);
            }
        }
        return configuration;
    }

    public Configuration create(String fileName) {
        return this.create(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration create(File file) {
        try {
            Configuration configuration;
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            try {
                configuration = this.create(stream);
            }
            finally {
                ((InputStream)stream).close();
            }
            return configuration;
        }
        catch (IOException e) {
            throw new TextProcessorFactoryException(e);
        }
    }

    public Configuration create(InputStream stream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(stream);
            return this.domConfigurationFactory.create(document);
        }
        catch (ParserConfigurationException e) {
            throw new TextProcessorFactoryException(e);
        }
        catch (IOException e) {
            throw new TextProcessorFactoryException(e);
        }
        catch (SAXException e) {
            throw new TextProcessorFactoryException(e);
        }
    }
}

