/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kefirsf.bb.TextProcessorFactoryException;
import org.kefirsf.bb.conf.Code;
import org.kefirsf.bb.conf.Configuration;
import org.kefirsf.bb.conf.Constant;
import org.kefirsf.bb.conf.Junk;
import org.kefirsf.bb.conf.NamedElement;
import org.kefirsf.bb.conf.NamedValue;
import org.kefirsf.bb.conf.Pattern;
import org.kefirsf.bb.conf.PatternElement;
import org.kefirsf.bb.conf.Scope;
import org.kefirsf.bb.conf.Template;
import org.kefirsf.bb.conf.TemplateElement;
import org.kefirsf.bb.conf.Text;
import org.kefirsf.bb.conf.Variable;
import org.kefirsf.bb.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomConfigurationFactory {
    private static final String SCHEMA_LOCATION = "http://kefirsf.org/kefirbb/schema";
    private static final String TAG_CODE = "code";
    private static final String TAG_CODE_ATTR_NAME = "name";
    private static final String TAG_CODE_ATTR_PRIORITY = "priority";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_VAR = "var";
    private static final String TAG_VAR_ATTR_NAME = "name";
    private static final String DEFAULT_VARIABLE_NAME = "variable";
    private static final String TAG_VAR_ATTR_PARSE = "parse";
    private static final boolean DEFAULT_PARSE_VALUE = true;
    private static final String TAG_VAR_ATTR_INHERIT = "inherit";
    private static final boolean DEFAULT_INHERIT_VALUE = false;
    private static final String TAG_VAR_ATTR_REGEX = "regex";
    private static final String TAG_VAR_ATTR_TRANSPARENT = "transparent";
    private static final String TAG_TEMPLATE = "template";
    private static final String TAG_SCOPE = "scope";
    private static final String TAG_SCOPE_ATTR_NAME = "name";
    private static final String TAG_SCOPE_ATTR_PARENT = "parent";
    private static final String TAG_SCOPE_ATTR_IGNORE_TEXT = "ignoreText";
    private static final String TAG_CODEREF = "coderef";
    private static final String TAG_CODEREF_ATTR_NAME = "name";
    private static final String TAG_PREFIX = "prefix";
    private static final String TAG_SUFFIX = "suffix";
    private static final String TAG_PARAMS = "params";
    private static final String TAG_PARAM = "param";
    private static final String TAG_PARAM_ATTR_NAME = "name";
    private static final String TAG_PARAM_ATTR_VALUE = "value";
    private static final String TAG_CONSTANT = "constant";
    private static final String TAG_CONSTANT_ATTR_VALUE = "value";
    private static final String TAG_CONSTANT_ATTR_IGNORE_CASE = "ignoreCase";
    private static final String TAG_JUNK = "junk";
    private static final String TAG_NESTING = "nesting";
    private static final String TAG_NESTING_ATTR_LIMIT = "limit";
    private static final String TAG_NESTING_ATTR_EXCEPTION = "exception";
    private static final DomConfigurationFactory instance = new DomConfigurationFactory();

    private DomConfigurationFactory() {
    }

    public static DomConfigurationFactory getInstance() {
        return instance;
    }

    public Configuration create(Document dc) {
        Scope root;
        Configuration configuration = new Configuration();
        this.parseNesting(configuration, dc);
        configuration.setParams(this.parseParams(dc));
        configuration.setPrefix(this.parseFix(dc, TAG_PREFIX));
        configuration.setSuffix(this.parseFix(dc, TAG_SUFFIX));
        NodeList scopeNodeList = dc.getDocumentElement().getElementsByTagNameNS(SCHEMA_LOCATION, TAG_SCOPE);
        Map<String, Scope> scopes = this.parseScopes(scopeNodeList);
        boolean fillRoot = false;
        if (!scopes.containsKey("ROOT")) {
            root = new Scope("ROOT");
            scopes.put("ROOT", root);
            fillRoot = true;
        } else {
            root = scopes.get("ROOT");
        }
        Map<String, Code> codes = this.parseCodes(dc, scopes);
        this.fillScopeCodes(scopeNodeList, scopes, codes);
        if (fillRoot) {
            root.setCodes(new HashSet<Code>(codes.values()));
        }
        configuration.setRootScope(root);
        return configuration;
    }

    private void parseNesting(Configuration configuration, Document dc) {
        NodeList list = dc.getElementsByTagNameNS(SCHEMA_LOCATION, TAG_NESTING);
        if (list.getLength() > 0) {
            Node el = list.item(0);
            configuration.setNestingLimit(this.nodeAttribute(el, TAG_NESTING_ATTR_LIMIT, 500));
            configuration.setPropagateNestingException(this.nodeAttribute(el, TAG_NESTING_ATTR_EXCEPTION, false));
        }
    }

    private Map<String, Object> parseParams(Document dc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        NodeList paramsElements = dc.getElementsByTagNameNS(SCHEMA_LOCATION, TAG_PARAMS);
        if (paramsElements.getLength() > 0) {
            Element paramsElement = (Element)paramsElements.item(0);
            NodeList paramElements = paramsElement.getElementsByTagNameNS(SCHEMA_LOCATION, TAG_PARAM);
            for (int i = 0; i < paramElements.getLength(); ++i) {
                Node paramElement = paramElements.item(i);
                String name = this.nodeAttribute(paramElement, "name", "");
                String value = this.nodeAttribute(paramElement, "value", "");
                if (name == null || name.length() <= 0) continue;
                params.put(name, value);
            }
        }
        return params;
    }

    private Template parseFix(Document dc, String tagname) {
        NodeList prefixElementList = dc.getElementsByTagNameNS(SCHEMA_LOCATION, tagname);
        Template fix = prefixElementList.getLength() > 0 ? this.parseTemplate(prefixElementList.item(0)) : new Template();
        return fix;
    }

    private void fillScopeCodes(NodeList scopeNodeList, Map<String, Scope> scopes, Map<String, Code> codes) {
        for (int i = 0; i < scopeNodeList.getLength(); ++i) {
            Element scopeElement = (Element)scopeNodeList.item(i);
            Scope scope = scopes.get(scopeElement.getAttribute("name"));
            HashSet<Code> scopeCodes = new HashSet<Code>();
            NodeList coderefs = scopeElement.getElementsByTagNameNS(SCHEMA_LOCATION, TAG_CODEREF);
            for (int j = 0; j < coderefs.getLength(); ++j) {
                Element ref = (Element)coderefs.item(j);
                String codeName = ref.getAttribute("name");
                Code code = codes.get(codeName);
                if (code == null) {
                    throw new TextProcessorFactoryException("Can't find code \"" + codeName + "\".");
                }
                scopeCodes.add(code);
            }
            NodeList inlineCodes = scopeElement.getElementsByTagNameNS(SCHEMA_LOCATION, TAG_CODE);
            for (int j = 0; j < inlineCodes.getLength(); ++j) {
                Element ice = (Element)inlineCodes.item(j);
                scopeCodes.add(this.parseCode(ice, scopes));
            }
            scope.setCodes(scopeCodes);
        }
    }

    private Map<String, Scope> parseScopes(NodeList scopeNodeList) {
        Scope scope;
        String name;
        Element scopeElement;
        int i;
        HashMap<String, Scope> scopes = new HashMap<String, Scope>();
        for (i = 0; i < scopeNodeList.getLength(); ++i) {
            scopeElement = (Element)scopeNodeList.item(i);
            name = scopeElement.getAttribute("name");
            if (name.length() == 0) {
                throw new TextProcessorFactoryException("Illegal scope name. Scope name can't be empty.");
            }
            scope = new Scope(name, this.nodeAttribute((Node)scopeElement, TAG_SCOPE_ATTR_IGNORE_TEXT, false));
            scopes.put(scope.getName(), scope);
        }
        for (i = 0; i < scopeNodeList.getLength(); ++i) {
            scopeElement = (Element)scopeNodeList.item(i);
            name = scopeElement.getAttribute("name");
            scope = (Scope)scopes.get(name);
            if (scope == null) {
                throw new TextProcessorFactoryException(MessageFormat.format("Can't find scope \"{0}\".", name));
            }
            String parentName = this.nodeAttribute(scopeElement, TAG_SCOPE_ATTR_PARENT);
            if (parentName == null) continue;
            Scope parent = (Scope)scopes.get(parentName);
            if (parent == null) {
                throw new TextProcessorFactoryException(MessageFormat.format("Can't find parent scope \"{0}\".", parentName));
            }
            scope.setParent(parent);
        }
        return scopes;
    }

    private Map<String, Code> parseCodes(Document dc, Map<String, Scope> scopes) {
        HashMap<String, Code> codes = new HashMap<String, Code>();
        NodeList codeNodeList = dc.getDocumentElement().getElementsByTagNameNS(SCHEMA_LOCATION, TAG_CODE);
        for (int i = 0; i < codeNodeList.getLength(); ++i) {
            Code code = this.parseCode((Element)codeNodeList.item(i), scopes);
            codes.put(code.getName(), code);
        }
        return codes;
    }

    private Code parseCode(Element codeElement, Map<String, Scope> scopes) {
        Code code = new Code(this.nodeAttribute((Node)codeElement, "name", Utils.generateRandomName()));
        code.setPriority(this.nodeAttribute((Node)codeElement, TAG_CODE_ATTR_PRIORITY, 0));
        NodeList templateElements = codeElement.getElementsByTagNameNS(SCHEMA_LOCATION, TAG_TEMPLATE);
        if (templateElements.getLength() <= 0) {
            throw new TextProcessorFactoryException("Illegal configuration. Can't find template of code.");
        }
        code.setTemplate(this.parseTemplate(templateElements.item(0)));
        NodeList patternElements = codeElement.getElementsByTagNameNS(SCHEMA_LOCATION, TAG_PATTERN);
        if (patternElements.getLength() <= 0) {
            throw new TextProcessorFactoryException("Illegal configuration. Can't find pattern of code.");
        }
        code.setPattern(this.parsePattern(patternElements.item(0), scopes));
        return code;
    }

    private Pattern parsePattern(Node node, Map<String, Scope> scopes) {
        LinkedList<PatternElement> elements = new LinkedList<PatternElement>();
        NodeList patternList = node.getChildNodes();
        int patternLength = patternList.getLength();
        if (patternLength <= 0) {
            throw new TextProcessorFactoryException("Invalid pattern. Pattern is empty.");
        }
        boolean ignoreCase = this.nodeAttribute(node, TAG_CONSTANT_ATTR_IGNORE_CASE, false);
        for (int k = 0; k < patternLength; ++k) {
            Node el = patternList.item(k);
            if (el.getNodeType() == 3) {
                elements.add(new Constant(el.getNodeValue(), ignoreCase));
                continue;
            }
            if (el.getNodeType() == 1 && el.getLocalName().equals(TAG_CONSTANT)) {
                elements.add(this.parseConstant(el, ignoreCase));
                continue;
            }
            if (el.getNodeType() == 1 && el.getLocalName().equals(TAG_VAR) && (k != 0 || this.nodeHasAttribute(el, TAG_VAR_ATTR_REGEX))) {
                elements.add(this.parseNamedElement(el, scopes));
                continue;
            }
            if (el.getNodeType() == 1 && el.getLocalName().equals(TAG_JUNK) && k != 0) {
                elements.add(new Junk());
                continue;
            }
            throw new TextProcessorFactoryException("Invalid pattern. Unknown XML element.");
        }
        return new Pattern((List<? extends PatternElement>)elements);
    }

    private Constant parseConstant(Node el, boolean ignoreCase) {
        return new Constant(this.nodeAttribute(el, "value"), this.nodeAttribute(el, TAG_CONSTANT_ATTR_IGNORE_CASE, ignoreCase));
    }

    private PatternElement parseNamedElement(Node el, Map<String, Scope> scopes) {
        NamedElement namedElement = this.nodeAttribute(el, TAG_VAR_ATTR_PARSE, true) && !this.nodeHasAttribute(el, TAG_VAR_ATTR_REGEX) ? this.parseText(el, scopes) : this.parseVariable(el);
        return namedElement;
    }

    private Text parseText(Node el, Map<String, Scope> scopes) {
        Text text;
        if (this.nodeAttribute(el, TAG_VAR_ATTR_INHERIT, false)) {
            text = new Text(this.nodeAttribute(el, "name", DEFAULT_VARIABLE_NAME), null, this.nodeAttribute(el, TAG_VAR_ATTR_TRANSPARENT, false));
        } else {
            String scopeName = this.nodeAttribute(el, TAG_SCOPE, "ROOT");
            Scope scope = scopes.get(scopeName);
            if (scope == null) {
                throw new TextProcessorFactoryException(MessageFormat.format("Scope \"{0}\" not found.", scopeName));
            }
            text = new Text(this.nodeAttribute(el, "name", DEFAULT_VARIABLE_NAME), scope, this.nodeAttribute(el, TAG_VAR_ATTR_TRANSPARENT, false));
        }
        return text;
    }

    private Variable parseVariable(Node el) {
        Variable variable = this.nodeHasAttribute(el, TAG_VAR_ATTR_REGEX) ? new Variable(this.nodeAttribute(el, "name", DEFAULT_VARIABLE_NAME), java.util.regex.Pattern.compile(this.nodeAttribute(el, TAG_VAR_ATTR_REGEX))) : new Variable(this.nodeAttribute(el, "name", DEFAULT_VARIABLE_NAME));
        return variable;
    }

    private Template parseTemplate(Node node) {
        LinkedList<TemplateElement> elements = new LinkedList<TemplateElement>();
        NodeList templateList = node.getChildNodes();
        for (int k = 0; k < templateList.getLength(); ++k) {
            Node el = templateList.item(k);
            if (el.getNodeType() == 1 && el.getLocalName().equals(TAG_VAR)) {
                elements.add(new NamedValue(this.nodeAttribute(el, "name", DEFAULT_VARIABLE_NAME)));
                continue;
            }
            elements.add(new Constant(el.getNodeValue()));
        }
        return new Template((List<? extends TemplateElement>)elements);
    }

    private boolean nodeAttribute(Node node, String attributeName, boolean defaultValue) {
        Node attribute;
        boolean value = defaultValue;
        if (node.hasAttributes() && (attribute = node.getAttributes().getNamedItem(attributeName)) != null) {
            value = Boolean.valueOf(attribute.getNodeValue());
        }
        return value;
    }

    private String nodeAttribute(Node node, String attributeName, String defaultValue) {
        Node attribute;
        String value = defaultValue;
        if (node.hasAttributes() && (attribute = node.getAttributes().getNamedItem(attributeName)) != null) {
            value = attribute.getNodeValue();
        }
        return value;
    }

    private String nodeAttribute(Node node, String attributeName) {
        Node attribute;
        String value = null;
        if (node.hasAttributes() && (attribute = node.getAttributes().getNamedItem(attributeName)) != null) {
            value = attribute.getNodeValue();
        }
        return value;
    }

    private int nodeAttribute(Node node, String attributeName, int defaultValue) {
        Node attribute;
        int value = defaultValue;
        if (node.hasAttributes() && (attribute = node.getAttributes().getNamedItem(attributeName)) != null) {
            value = Integer.decode(attribute.getNodeValue());
        }
        return value;
    }

    private boolean nodeHasAttribute(Node node, String attributeName) {
        return node.hasAttributes() && node.getAttributes().getNamedItem(attributeName) != null;
    }
}

