/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.kefirsf.bb.conf.Code;
import org.kefirsf.bb.conf.Configuration;
import org.kefirsf.bb.conf.Constant;
import org.kefirsf.bb.conf.Junk;
import org.kefirsf.bb.conf.NamedValue;
import org.kefirsf.bb.conf.Pattern;
import org.kefirsf.bb.conf.PatternElement;
import org.kefirsf.bb.conf.Scope;
import org.kefirsf.bb.conf.Template;
import org.kefirsf.bb.conf.TemplateElement;
import org.kefirsf.bb.conf.Text;
import org.kefirsf.bb.conf.Variable;
import org.kefirsf.bb.proc.BBProcessor;
import org.kefirsf.bb.proc.PatternConstant;
import org.kefirsf.bb.proc.PatternJunk;
import org.kefirsf.bb.proc.ProcCode;
import org.kefirsf.bb.proc.ProcNamedValue;
import org.kefirsf.bb.proc.ProcPattern;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.ProcScope;
import org.kefirsf.bb.proc.ProcTemplate;
import org.kefirsf.bb.proc.ProcTemplateElement;
import org.kefirsf.bb.proc.ProcText;
import org.kefirsf.bb.proc.ProcVariable;
import org.kefirsf.bb.proc.TemplateConstant;

class ProcessorBuilder {
    private final Configuration conf;
    private Map<Scope, ProcScope> createdScopes;
    private Map<Code, ProcCode> codes;
    private Map<Constant, PatternConstant> constants;

    ProcessorBuilder(Configuration conf) {
        this.conf = conf;
    }

    public BBProcessor build() {
        this.createdScopes = new HashMap<Scope, ProcScope>();
        this.codes = new HashMap<Code, ProcCode>();
        this.constants = new HashMap<Constant, PatternConstant>();
        BBProcessor processor = new BBProcessor();
        processor.setScope(this.createScope(this.conf.getRootScope()));
        processor.setPrefix(this.createTemplate(this.conf.getPrefix()));
        processor.setSuffix(this.createTemplate(this.conf.getSuffix()));
        processor.setParams(this.conf.getParams());
        processor.setConstants(new HashSet<PatternConstant>(this.constants.values()));
        processor.setNestingLimit(this.conf.getNestingLimit());
        processor.setPropagateNestingException(this.conf.isPropagateNestingException());
        return processor;
    }

    private ProcScope createScope(Scope scope) {
        ProcScope created = this.createdScopes.get(scope);
        if (created == null) {
            created = new ProcScope(scope.getName());
            this.createdScopes.put(scope, created);
            created.setIgnoreText(scope.isIgnoreText());
            if (scope.getParent() != null) {
                created.setParent(this.createScope(scope.getParent()));
            }
            HashSet<ProcCode> scopeCodes = new HashSet<ProcCode>();
            for (Code code : scope.getCodes()) {
                scopeCodes.add(this.createCode(code));
            }
            created.setScopeCodes(scopeCodes);
            created.init();
        }
        return created;
    }

    private ProcCode createCode(Code defCode) {
        if (defCode.getPattern() == null) {
            throw new IllegalStateException("Field pattern can't be null.");
        }
        if (defCode.getTemplate() == null) {
            throw new IllegalStateException("Field template can't be null.");
        }
        ProcCode code = this.codes.get(defCode);
        if (code == null) {
            code = new ProcCode(this.createPattern(defCode.getPattern()), this.createTemplate(defCode.getTemplate()), defCode.getName(), defCode.getPriority());
            this.codes.put(defCode, code);
        }
        return code;
    }

    private ProcTemplate createTemplate(Template template) {
        ArrayList<ProcTemplateElement> elements = new ArrayList<ProcTemplateElement>();
        if (template.getElements() != null) {
            for (TemplateElement element : template.getElements()) {
                if (element instanceof Constant) {
                    elements.add(new TemplateConstant(((Constant)element).getValue()));
                    continue;
                }
                if (!(element instanceof NamedValue)) continue;
                elements.add(new ProcNamedValue(((NamedValue)element).getName()));
            }
            return new ProcTemplate(elements);
        }
        return ProcTemplate.EMPTY;
    }

    private ProcPattern createPattern(Pattern pattern) {
        if (pattern.getElements() == null || pattern.getElements().isEmpty()) {
            throw new IllegalStateException("Pattern elements list can't be empty.");
        }
        ArrayList<ProcPatternElement> elements = new ArrayList<ProcPatternElement>();
        for (PatternElement element : pattern.getElements()) {
            if (element instanceof Variable) {
                elements.add(new ProcVariable(((Variable)element).getName(), ((Variable)element).getRegex()));
                continue;
            }
            if (element instanceof Text) {
                elements.add(this.create((Text)element));
                continue;
            }
            if (element instanceof Constant) {
                elements.add(this.createPatternConstant((Constant)element));
                continue;
            }
            if (!(element instanceof Junk)) continue;
            elements.add(new PatternJunk());
        }
        return new ProcPattern(elements);
    }

    private PatternConstant createPatternConstant(Constant constant) {
        if (!this.constants.containsKey(constant)) {
            this.constants.put(constant, new PatternConstant(constant.getValue(), constant.isIgnoreCase()));
        }
        return this.constants.get(constant);
    }

    private ProcPatternElement create(Text text) {
        Scope scope = text.getScope();
        if (scope != null) {
            return new ProcText(text.getName(), this.createScope(scope), text.isTransparent());
        }
        return new ProcText(text.getName(), text.isTransparent());
    }
}

