/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.conf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kefirsf.bb.conf.Code;
import org.kefirsf.bb.util.Exceptions;
import org.kefirsf.bb.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    public static final String ROOT = "ROOT";
    public static final boolean DEFAULT_IGNORE_TEXT = false;
    private String name;
    private Scope parent;
    private boolean ignoreText = false;
    private Set<Code> codes = new HashSet<Code>();

    public Scope() {
        this.name = Utils.generateRandomName();
    }

    public Scope(String name) {
        this.name = name;
        this.parent = null;
        this.ignoreText = false;
    }

    public Scope(String name, boolean ignoreText) {
        this.name = name;
        this.parent = null;
        this.ignoreText = ignoreText;
    }

    public Scope(String name, Scope parent, boolean ignoreText) {
        this.name = name;
        this.parent = parent;
        this.ignoreText = ignoreText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Scope getParent() {
        return this.parent;
    }

    public void setParent(Scope parent) {
        this.parent = parent;
    }

    public boolean isIgnoreText() {
        return this.ignoreText;
    }

    public void setIgnoreText(boolean ignoreText) {
        this.ignoreText = ignoreText;
    }

    public Set<Code> getCodes() {
        return Collections.unmodifiableSet(this.codes);
    }

    public void setCodes(Set<Code> codes) {
        Exceptions.nullArgument("codes", codes);
        this.codes.clear();
        this.codes.addAll(codes);
    }

    public void addCode(Code code) {
        this.codes.add(code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope = (Scope)o;
        return this.name.equals(scope.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

