/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.kefirsf.bb.TextProcessorAdapter;
import org.kefirsf.bb.TextProcessorNestingException;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.PatternConstant;
import org.kefirsf.bb.proc.ProcScope;
import org.kefirsf.bb.proc.ProcTemplate;
import org.kefirsf.bb.proc.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BBProcessor
extends TextProcessorAdapter {
    private ProcScope scope = null;
    private ProcTemplate prefix = null;
    private ProcTemplate suffix = null;
    private Map<String, Object> params = null;
    private Set<PatternConstant> constants;
    private int nestingLimit = 0;
    private boolean propagateNestingException = false;

    @Override
    public CharSequence process(CharSequence source) {
        StringBuilder target;
        block5: {
            Context context = new Context();
            target = new StringBuilder(source.length());
            context.setTarget(target);
            Source source1 = new Source(source);
            source1.setConstantSet(this.constants);
            context.setSource(source1);
            context.setScope(this.scope);
            context.setNestingLimit(this.nestingLimit * 2);
            if (this.params != null) {
                for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                    context.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            try {
                this.prefix.generate(context);
                this.scope.process(context);
                this.suffix.generate(context);
            }
            catch (IOException e) {
            }
            catch (NestingException e) {
                target = new StringBuilder(0);
                if (!this.propagateNestingException) break block5;
                throw new TextProcessorNestingException(this.nestingLimit);
            }
        }
        return target;
    }

    public void setScope(ProcScope scope) throws IllegalStateException {
        if (this.scope != null) {
            throw new IllegalStateException("Can't change the root scope.");
        }
        this.scope = scope;
    }

    public void setPrefix(ProcTemplate prefix) throws IllegalStateException {
        if (this.prefix != null) {
            throw new IllegalStateException("Can't change the prefix.");
        }
        this.prefix = prefix;
    }

    public void setSuffix(ProcTemplate suffix) {
        if (this.suffix != null) {
            throw new IllegalStateException("Can't change the suffix.");
        }
        this.suffix = suffix;
    }

    public void setParams(Map<String, Object> params) {
        if (this.params != null) {
            throw new IllegalStateException("Can't change parameters.");
        }
        this.params = Collections.unmodifiableMap(params);
    }

    public void setConstants(Set<PatternConstant> constants) {
        this.constants = constants;
    }

    public void setNestingLimit(int nestingLimit) {
        this.nestingLimit = nestingLimit;
    }

    public void setPropagateNestingException(boolean propagateNestingException) {
        this.propagateNestingException = propagateNestingException;
    }
}

