/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.io.IOException;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.ProcPattern;
import org.kefirsf.bb.proc.ProcTemplate;
import org.kefirsf.bb.proc.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcCode
implements Comparable<ProcCode> {
    private final ProcTemplate template;
    private final ProcPattern pattern;
    private final int priority;
    private final String name;

    public ProcCode(ProcPattern pattern, ProcTemplate template, String name, int priority) {
        this.template = template;
        this.priority = priority;
        this.name = name;
        this.pattern = pattern;
    }

    public boolean process(Context context) throws IOException, NestingException {
        Context codeContext = new Context(context);
        if (this.pattern.parse(codeContext)) {
            codeContext.mergeWithParent();
            this.template.generate(context);
            return true;
        }
        return false;
    }

    public boolean suspicious(Source source) {
        return this.pattern.suspicious(source);
    }

    @Override
    public int compareTo(ProcCode code) {
        return this.priority - code.priority;
    }

    public String getName() {
        return this.name;
    }

    public boolean startsWithConstant() {
        return this.pattern.startsWithConstant();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcCode procCode = (ProcCode)o;
        return !(this.name != null ? !this.name.equals(procCode.name) : procCode.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

