/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.util.Collections;
import java.util.List;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.PatternConstant;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcPattern {
    private final List<? extends ProcPatternElement> elements;
    private final ProcPatternElement firstElement;

    public ProcPattern(List<? extends ProcPatternElement> elements) {
        this.elements = Collections.unmodifiableList(elements);
        if (this.elements.isEmpty()) {
            throw new IllegalArgumentException("Parameter \"elements\" can't be empty.");
        }
        this.firstElement = this.elements.get(0);
    }

    public boolean suspicious(Source source) {
        return this.firstElement.isNextIn(source);
    }

    public boolean parse(Context context) throws NestingException {
        boolean flag = true;
        Source source = context.getSource();
        int offset = source.getOffset();
        int patternSize = this.elements.size();
        for (int i = 0; i < patternSize && flag; ++i) {
            ProcPatternElement current = this.elements.get(i);
            ProcPatternElement next = i < patternSize - 1 ? this.elements.get(i + 1) : context.getTerminator();
            flag = source.hasNext() && current.parse(context, next);
        }
        if (!flag) {
            source.setOffset(offset);
        }
        return flag;
    }

    public boolean startsWithConstant() {
        return this.firstElement instanceof PatternConstant;
    }
}

