/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.kefirsf.bb.TextProcessorFactoryException;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.ProcCode;
import org.kefirsf.bb.proc.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcScope {
    private final String name;
    private ProcScope parent = null;
    private Set<ProcCode> scopeCodes = null;
    private boolean ignoreText = false;
    private ProcCode[] cachedCodes = null;
    private boolean initialized = false;
    private boolean hasCrazyCode = false;

    public ProcScope(String name) {
        this.name = name;
    }

    public void process(Context context) throws IOException, NestingException {
        Source source = context.getSource();
        while (context.hasNextAdjustedForTerminator()) {
            int offset = source.getOffset();
            boolean parsed = false;
            if ((source.nextMayBeConstant() || this.hasCrazyCode) && !context.checkBadTag(offset)) {
                boolean suspicious = false;
                for (ProcCode code : this.cachedCodes) {
                    if (!code.suspicious(source)) continue;
                    suspicious = true;
                    if (!code.process(context)) continue;
                    parsed = true;
                    break;
                }
                if (suspicious && !parsed) {
                    context.addBadTag(offset);
                }
            }
            if (parsed) continue;
            if (this.ignoreText) {
                source.incOffset();
                continue;
            }
            context.getTarget().append(source.next());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setParent(ProcScope parent) {
        this.parent = parent;
    }

    public void setScopeCodes(Set<ProcCode> codes) {
        this.scopeCodes = codes;
    }

    public void init() {
        if (this.parent != null && !this.parent.isInitialized()) {
            throw new TextProcessorFactoryException("Can't init scope.");
        }
        this.cacheCodes();
        this.initialized = true;
    }

    private ProcCode[] getCodes() {
        if (!this.initialized) {
            throw new IllegalStateException("Scope is not initialized.");
        }
        return this.cachedCodes;
    }

    private void cacheCodes() {
        HashSet<ProcCode> set = new HashSet<ProcCode>();
        if (this.parent != null) {
            set.addAll(Arrays.asList(this.parent.getCodes()));
        }
        if (this.scopeCodes != null) {
            set.addAll(this.scopeCodes);
        }
        this.cachedCodes = set.toArray(new ProcCode[set.size()]);
        Arrays.sort(this.cachedCodes, new Comparator<ProcCode>(){

            @Override
            public int compare(ProcCode code1, ProcCode code2) {
                return code2.compareTo(code1);
            }
        });
        for (ProcCode code : this.cachedCodes) {
            this.hasCrazyCode = this.hasCrazyCode || !code.startsWithConstant();
        }
    }

    public void setIgnoreText(boolean ignoreText) {
        this.ignoreText = ignoreText;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

