/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.ProcNamedElement;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

public class ProcVariable
extends ProcNamedElement
implements ProcPatternElement {
    private final Pattern regex;

    public ProcVariable(String name, Pattern regex) {
        super(name);
        this.regex = regex;
    }

    public boolean parse(Context context, ProcPatternElement terminator) {
        Object attr;
        Source source = context.getSource();
        int offset = source.getOffset();
        int end = terminator != null ? terminator.findIn(context.getSource()) : context.getSource().getLength();
        if (end < 0) {
            return false;
        }
        CharSequence value = source.sub(end);
        if (this.regex != null) {
            Matcher matcher = this.regex.matcher(value);
            if (matcher.lookingAt()) {
                int lend = matcher.end();
                end = offset + lend;
                value = value.subSequence(0, lend);
            } else {
                return false;
            }
        }
        if ((attr = context.getLocalAttribute(this.getName())) == null || attr.equals(value)) {
            if (attr == null) {
                this.setAttribute(context, value);
            }
            source.incOffset(end - offset);
            return true;
        }
        return false;
    }

    public boolean isNextIn(Source source) {
        return this.regex != null && this.regex.matcher(source.subToEnd()).lookingAt();
    }

    public int findIn(Source source) {
        if (this.regex != null) {
            Matcher matcher = this.regex.matcher(source.subToEnd());
            if (matcher.find()) {
                return matcher.start();
            }
            return -1;
        }
        return -1;
    }

    public String toString() {
        return "variable:" + this.getName();
    }
}

